; xytester.asm:  X-Y monitor tester
;
; Copyright 1992, 1995 Eric Smith
;
; xytester.asm is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License version 2 as published by
; the Free Software Foundation.  Note that I am not granting permission to
; redistribute or modify xytester.asm under the terms of any later version of
; the General Public License.
;
; This program is distributed in the hope that it will be useful (or at least
; amusing), but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
; Public License for more details.
;
; You should have received a copy of the GNU General Public License along with
; this program (in the file "COPYING"); if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
; $Header: /usr/home/kolwynia/eric/pic/xytester/RCS/xytester.asm,v 1.7 1995/06/06 18:03:56 eric Exp eric $

	device	pic16c54,xt_osc,wdt_off,protect_off

f	equ	1		; for destination argument
w	equ	0		; for destination argument

ind	equ	0		; used for indirects thru fsr
rtcc	equ	1		; real time clock/counter
pc	equ	2		; program counter
fsr	equ	4		; file select register (index register)

status	equ	3		; status register:
cf	equ	0		;  bit 0 = carry bit flag
dcf	equ	1		;  bit 1 = digit carry bit flag
zf	equ	2		;  bit 2 = zero bit flag
pdf	equ	3		;  bit 3 = power down bit flag
tof	equ	4		;  bit 4 = time out bit flag
				;  bits 5,6,7 do not apply to pic16c54


nothing	equ	0		; used to return nothing from subroutines

true	equ	0ffh		; booleans
false	equ	00h

porta	equ	5		; i/o port ra:
addr0	equ	0		;  bit 0 = a0 to d/a
addr1	equ	1		;  bit 1 = a1 to d/a
dacs	equ	2		;  bit 2 = cs/ to d/a
pzt	equ	3		;  bit 3 = pzt speaker

portb	equ	6		; i/o port rb:


ram	equ	08h		; start of RAM
body	equ	000h		; beginning of program


	org	ram		; start of RAM

one:	ds	1		; holds the value of "1" for incrementing w-reg
zero:	ds	1		; holds the value 0 for doing 2s complement

temp:	ds	1		; very temporary

startx:	ds	1		; starting x coord of vector
starty:	ds	1		; starting y coord of vector
endx:	ds	1
endy:	ds	1

xinc:	ds	2		; delta for x coord
yinc:	ds	2		; delta for y coord

thetax:	ds	2
thetay:	ds	2

mode:	ds	1
iter:	ds	2

	org	body		; start of ROM


; call extenders

inithw:	goto	inithwx
vector:	goto	vectorx
point:	goto	pointx


; This is a sine wave for 360 degrees per 256 table entries, scaled by
; 127, such that 1.0 = $7f hex.
; Only 65 locations (0 to 90 degrees in steps of 2pi/256) are used to save
; space.
; The values are signed fractions, i.e., s.fffffff
; All values in the table are positive since it is for the first
; quadrant.

sinetbl:
	addwf	pc
	retw	000h,003h,006h,009h,00ch,010h,013h,016h
	retw	019h,01ch,01fh,022h,025h,028h,02bh,02eh
	retw	031h,033h,036h,039h,03ch,03fh,041h,044h
	retw	047h,049h,04ch,04eh,051h,053h,055h,058h
	retw	05ah,05ch,05eh,060h,062h,064h,066h,068h
	retw	06ah,06bh,06dh,06fh,070h,071h,073h,074h
	retw	075h,076h,078h,079h,07ah,07ah,07bh,07ch
	retw	07dh,07dh,07eh,07eh,07eh,07fh,07fh,07fh
	retw	07fh

; Compute sin of angle in w, return in temp
; 21 cycles (including call)

sin:	movwf	temp		; 1
	btfsc	temp,6		; 1 is it the 2nd half of a half cycle?
	subwf	zero,w		; 1 then complement to effect a subtract from 64
	andlw	07fh		; 1 reduce to 6 bits for 90 degrees	
	call	sinetbl		; 6  and get amplitude

	btfsc	temp,7		; 1 is amplitude supposed to be negative?
	subwf	zero,w		; 1 change polarity of sine amplitude

	movwf	temp		; 1
	retlw	nothing		; 2


; mode tables

maxmode	equ	3

initmode:
	addwf	pc
	nop
	goto	inmode1
	goto	inmode2
	goto	inmode3

domode:
	addwf	pc
	nop
	goto	domode12
	goto	domode12
	goto	domode12


; draw a point

pointx:
	movf	startx,w	; move the x data to the port
	movwf	portb
	movlw	04h		; strobe the d/a
	movwf	porta
	movlw	00h
	movwf	porta
	movlw	04h
	movwf	porta
	movf	starty,w	; move the y data to the port
	movwf	portb
	movlw	05h		; and strobe the d/a
	movwf	porta
	movlw	01h
	movwf	porta
	movlw	05h
	movwf	porta
	retlw	nothing


; draw a vector

vectorx:
	movf	xinc,w		; test xinc for zero
	btfss	status,zf
	goto	vec1

	movf	endx,w
	movwf	startx

vec1:
	movf	yinc,w		; test yinc for zero
	btfss	status,zf
	goto	vecloop

	movf	endy,w
	movwf	starty
	
vecloop:
	movf	startx,w	; move the x data to the port
	movwf	portb
	movlw	04h		; strobe the d/a
	movwf	porta
	movlw	00h
	movwf	porta
	movlw	04h
	movwf	porta
	movf	starty,w	; move the y data to the port
	movwf	portb
	movlw	05h		; and strobe the d/a
	movwf	porta
	movlw	01h
	movwf	porta
	movlw	05h
	movwf	porta

	movf	xinc,w		; add the deltas to the coords
	addwf	startx
	movf	yinc,w
	addwf	starty

	movf	endx,w		; test x coord for completion
	xorwf	startx,w
	btfss	status,zf
	goto	vecloop

	movlw	000h
	movwf	xinc
	
	movf	endy,w		; text y coord for completion
	xorwf	starty,w
	btfss	status,zf
	goto	vecloop
	
	movlw	000h
	movwf	yinc

; We don't need the following lines which would explicitly copy the vector's
; end coordinates to the start for the next vector, because we actually used
; startx and starty as the counters!
;	movf	xend,w
;	movwf	startx
;	movf	yend,w
;	movwf	starty
	retlw	nothing


;initialize the hardware

inithwx:
	movlw	1		; initialize the value of one to allowing
	movwf	one		; incrementing the w register using "addwf one,w"

	clrf	zero		; initialize the value of zero

	movlw	0f0h		; porta:
	tris	porta		;  bit 0 = output (a0)
				;  bit 1 = output (a1)
				;  bit 2 = output (cs/)
				;  bit 3 = output (pzt)
				;  bits 4-7 = inputs (no pins on 16c54)

	bcf	porta,pzt	; 0 volts on speaker

	movlw	00h		; portb:
	tris	portb		;  data to d/a converters

	movlw	0ffh		; drive port b output pins high
	movwf	portb

	retlw	nothing


;======================== program entry point =========================

reset:	call	inithw		; initialize hardware
;	call	beep


;======================== main loop =========================

points	equ	20000

main:
	movlw	maxmode
	movwf	mode
m1:
	movf	mode,w
	call	initmode

	movlw	points>
	movwf	iter
	movlw	points<
	movwf	iter+1

mainloop:
	decfsz	iter
	goto	ml1
	decfsz	iter+1
	goto	ml1
	decfsz	mode
	goto	m1
	goto	main
ml1:
	movf	mode,w
	goto	domode


inmode1:
	clrf	thetax
	clrf	thetax+1
	clrf	thetay
	clrf	thetay+1

xcon1	equ	5*64
ycon1	equ	6*64

	movlw	xcon1>
	movwf	xinc
	movlw	xcon1<
	movwf	xinc+1

	movlw	ycon1>
	movwf	yinc
	movlw	ycon1<
	movwf	yinc+1

	retlw	nothing

inmode2:
	clrf	thetax
	clrf	thetax+1
	clrf	thetay
	movlw	040h
	movwf	thetay+1

xcon2	equ	256
ycon2	equ	384

	movlw	xcon2>
	movwf	xinc
	movlw	xcon2<
	movwf	xinc+1

	movlw	ycon2>
	movwf	yinc
	movlw	ycon2<
	movwf	yinc+1

	retlw	nothing

inmode3:
	clrf	thetax
	clrf	thetax+1
	clrf	thetay
	movlw	040h
	movwf	thetay+1

xcon3	equ	256
ycon3	equ	256

	movlw	xcon3>
	movwf	xinc
	movlw	xcon3<
	movwf	xinc+1

	movlw	ycon3>
	movwf	yinc
	movlw	ycon3<
	movwf	yinc+1

	retlw	nothing

domode12:
	movf	xinc,w
	addwf	thetax
	movf	xinc+1,w
	btfsc	status,cf
	addwf	one,w
	addwf	thetax+1

	movf	yinc,w
	addwf	thetay
	movf	yinc+1,w
	btfsc	status,cf
	addwf	one,w
	addwf	thetay+1

	movf	thetax+1,w
	call	sin
	movf	temp,w
	xorlw	080h
	movwf	startx

	movf	thetay+1,w
	call	sin
	movf	temp,w
	xorlw	080h
	movwf	starty

	call	point
	goto	mainloop

	org	01ffh		; reset vector of pic16c54
	goto	reset		; start of program

	end
