//
// 
// Driver for Capcom System 1
//
//
// See drivers.h for description of fields
//

#include "allegro.h"
#include "..\drivers.h"

struct GFXROMINFO Strider_RomInfo[] =
{
   { "strider\\strider.02", 0x000000, 0x80000 },
   { "strider\\strider.06", 0x080000, 0x80000 },
   { "strider\\strider.04", 0x100000, 0x80000 },
   { "strider\\strider.08", 0x180000, 0x80000 },

   { "strider\\strider.01", 0x200000, 0x80000 },
   { "strider\\strider.05", 0x280000, 0x80000 },
   { "strider\\strider.03", 0x300000, 0x80000 },
   { "strider\\strider.07", 0x380000, 0x80000 },
};


RGB Strider_Colours_0[] =
{
	{0x00,0x00,0x00}, {0x3f,0x00,0x2d}, {0x00,0x1b,0x00}, {0x00,0x36,0x00},
	{0x1b,0x00,0x00}, {0x2d,0x00,0x00}, {0x00,0x24,0x3f}, {0x3f,0x00,0x00},
	{0x00,0x12,0x00}, {0x00,0x00,0x00}, {0x00,0x00,0x1b}, {0x00,0x00,0x2d},
	{0x00,0x12,0x3f}, {0x3f,0x24,0x00}, {0x3f,0x3f,0x00}, {0x3f,0x3f,0x3f}
};

RGB Strider_Colours_1[] =
{
	{0x08,0x08,0x12}, {0x3f,0x12,0x08}, {0x36,0x00,0x00}, {0x00,0x00,0x1b},
	{0x00,0x00,0x2d}, {0x00,0x12,0x3f}, {0x00,0x24,0x3f}, {0x00,0x2d,0x3f},
	{0x3f,0x3f,0x08}, {0x00,0x00,0x00}, {0x24,0x08,0x00}, {0x12,0x08,0x00},
	{0x2d,0x12,0x00}, {0x3f,0x1b,0x00}, {0x3f,0x24,0x00}, {0x3f,0x3f,0x3f}
};

RGB Strider_Colours_2[] =
{
	{0x08,0x08,0x12}, {0x3f,0x00,0x2d}, {0x36,0x2d,0x3f}, {0x3f,0x36,0x08},
	{0x3f,0x00,0x08}, {0x00,0x2d,0x00}, {0x08,0x24,0x3f}, {0x2d,0x00,0x1b},
	{0x00,0x08,0x1b}, {0x00,0x00,0x00}, {0x36,0x2d,0x24}, {0x2d,0x24,0x1b},
	{0x00,0x00,0x2d}, {0x3f,0x1b,0x00}, {0x3f,0x12,0x08}, {0x3f,0x3f,0x3f}
};

RGB Strider_Colours_3[] =
{
	{0x00,0x00,0x00}, {0x00,0x00,0x00}, {0x08,0x08,0x08}, {0x08,0x08,0x08},
	{0x12,0x12,0x12}, {0x1b,0x1b,0x1b}, {0x24,0x24,0x24}, {0x24,0x24,0x24},
	{0x2d,0x2d,0x2d}, {0x2d,0x2d,0x2d}, {0x36,0x36,0x36}, {0x36,0x36,0x36},
	{0x3f,0x3f,0x3f}, {0x3f,0x3f,0x3f}, {0x3f,0x3f,0x3f}, {0x3f,0x3f,0x3f}
};

struct PALETTE Strider_Palettes[] =
{
    { 16, Strider_Colours_0 },
    { 16, Strider_Colours_1 },
    { 16, Strider_Colours_2 },
    { 16, Strider_Colours_3 },
};

#define CHAR_LAYOUT(LAYOUT, CHARS, PLANE_SEP) \
struct GFXLAYOUT LAYOUT =        \
{                                        \
        8,8,    /* 8*8 chars */             \
        CHARS,  /* ???? chars */        \
        4,       /* 4 bits per pixel */     \
        { PLANE_SEP+8,PLANE_SEP,8,0 },     \
        { 0,1,2,3,4,5,6,7, },                         \
        { 0*8, 2*8, 4*8, 6*8, 8*8, 10*8, 12*8, 14*8,}, \
        16*8    /* every sprite takes 32*8*2 consecutive bytes */\
};

#define SPRITE_LAYOUT(LAYOUT, SPRITES, SPRITE_SEP2, PLANE_SEP) \
struct GFXLAYOUT LAYOUT = \
{                                               \
        16,16,   /* 16*16 sprites */             \
        SPRITES,  /* ???? sprites */            \
        4,       /* 4 bits per pixel */            \
        { PLANE_SEP+8,PLANE_SEP,8,0 },            \
        { SPRITE_SEP2+0,SPRITE_SEP2+1,SPRITE_SEP2+2,SPRITE_SEP2+3, \
          SPRITE_SEP2+4,SPRITE_SEP2+5,SPRITE_SEP2+6,SPRITE_SEP2+7,  \
          0,1,2,3,4,5,6,7, },\
        { 0*8, 2*8, 4*8, 6*8, 8*8, 10*8, 12*8, 14*8, \
           16*8, 18*8, 20*8, 22*8, 24*8, 26*8, 28*8, 30*8, }, \
        32*8    /* every sprite takes 32*8*2 consecutive bytes */ \
};

#define TILE32_LAYOUT(LAYOUT, TILES, SEP, PLANE_SEP) \
struct GFXLAYOUT LAYOUT =                                   \
{                                                                  \
        32,32,   /* 32*32 tiles */                                 \
        TILES,   /* ????  tiles */                                 \
        4,       /* 4 bits per pixel */                            \
        { PLANE_SEP+8,PLANE_SEP,8,0},                                        \
        {                                                          \
           SEP+0,SEP+1,SEP+2,SEP+3, SEP+4,SEP+5,SEP+6,SEP+7,       \
           0,1,2,3,4,5,6,7,                                        \
           16+SEP+0,16+SEP+1,16+SEP+2,                             \
           16+SEP+3,16+SEP+4,16+SEP+5,                             \
           16+SEP+6,16+SEP+7,                                      \
           16+0,16+1,16+2,16+3,16+4,16+5,16+6,16+7                 \
        },                                                         \
        {                                                          \
           0*32, 1*32, 2*32, 3*32, 4*32, 5*32, 6*32, 7*32,         \
           8*32, 9*32, 10*32, 11*32, 12*32, 13*32, 14*32, 15*32,   \
           16*32, 17*32, 18*32, 19*32, 20*32, 21*32, 22*32, 23*32, \
           24*32, 25*32, 26*32, 27*32, 28*32, 29*32, 30*32, 31*32  \
        },                                                         \
        4*32*8    /* every sprite takes 32*8*4 consecutive bytes */\
};

CHAR_LAYOUT(charlayout_strider, 2048, 0x100000*8)
SPRITE_LAYOUT(spritelayout_strider, 0x2600, 0x80000*8, 0x100000*8)
SPRITE_LAYOUT(tilelayout_strider,   8192-2048, 0x80000*8, 0x100000*8)
TILE32_LAYOUT(tilelayout32_strider, 4096-512,  0x080000*8, 0x100000*8)




struct GFXINFO Strider_GfxInfo[] =
{
   { 0x2f0000, &charlayout_strider },
   { 0x004000, &spritelayout_strider },
   { 0x050000, &tilelayout_strider },
   { 0x200000, &tilelayout32_strider }
};


struct GAMEINFO Strider =
{
   "Strider",
   8,	Strider_RomInfo,
   4,	Strider_GfxInfo,
   4,	Strider_Palettes,
   0
};
