//
///// BOBBLE-BOBBLE DRIVER DATA /////////////////////
// added 31 OCT 1997 by Chris "Zwaxy" Moore
//       chris.moore@writeme.com
//

#include "allegro.h"
#include "..\drivers.h"

#warning Palette adjustment needed for boblbobl
#warning Palette adjustment needed for 1942
#warning Palette adjustment needed for bombjack

struct GFXROMINFO BoblBobl_RomInfo[] =
{
   { "boblbobl\\bb6",  0x0000,  0x8000 }, // each of these roms are 32k apiece
   { "boblbobl\\bb7",  0x8000,  0x8000 },
   { "boblbobl\\bb8",  0x10000, 0x8000 },
   { "boblbobl\\bb9",  0x18000, 0x8000 },
   { "boblbobl\\bb10", 0x20000, 0x8000 },
   { "boblbobl\\bb11", 0x28000, 0x8000 },
   { "boblbobl\\bb12", 0x30000, 0x8000 },
   { "boblbobl\\bb13", 0x38000, 0x8000 },
   { "boblbobl\\bb14", 0x40000, 0x8000 },
   { "boblbobl\\bb15", 0x48000, 0x8000 },
   { "boblbobl\\bb16", 0x50000, 0x8000 },
   { "boblbobl\\bb17", 0x58000, 0x8000 }
};

RGB BoblBobl_Colours_0[] = {
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0xFF, 0x55, 0x77}, {0xFF, 0x77, 0x77},
{0xFF, 0xFF, 0x66}, {0xAA, 0x00, 0x00}, {0xFF, 0x00, 0x00}, {0xFF, 0xFF, 0xFF},
{0xFF, 0x88, 0x00}, {0x00, 0xFF, 0x00}, {0xFF, 0xBB, 0x00}, {0xFF, 0x66, 0x00},
{0x00, 0xAA, 0x00}, {0xCC, 0xCC, 0xFF}, {0xFF, 0xFF, 0xFF}, {0x00, 0x00, 0x00}
};

RGB BoblBobl_Colours_1[] = {
{0x00, 0x00, 0x00}, {0xFF, 0x00, 0x77}, {0xFF, 0xFF, 0xFF}, {0xFF, 0xFF, 0x00},
{0xFF, 0xBB, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00},
{0x55, 0x55, 0x55}, {0x44, 0x44, 0x44}, {0xFF, 0xFF, 0xFF}, {0xBB, 0xBB, 0xBB},
{0x99, 0x99, 0x99}, {0x77, 0x77, 0x77}, {0xFF, 0x00, 0x00}, {0x00, 0x00, 0x00}
};

RGB BoblBobl_Colours_2[] = {
{0x00, 0x00, 0x00}, {0xDD, 0x44, 0x00}, {0xFF, 0x77, 0x77}, {0xFF, 0x88, 0x00},
{0xFF, 0xFF, 0x00}, {0x00, 0xFF, 0x00}, {0xFF, 0x00, 0x77}, {0x66, 0x66, 0xFF},
{0x00, 0x00, 0xCC}, {0xAA, 0xAA, 0xDD}, {0x88, 0x88, 0xBB}, {0x66, 0x66, 0xBB},
{0xFF, 0xAA, 0xAA}, {0x00, 0xBB, 0x00}, {0x00, 0xFF, 0x00}, {0x00, 0x00, 0x00}
};

RGB BoblBobl_Colours_3[] = { //
{0x00, 0x00, 0x00}, {0xDD, 0x44, 0x00}, {0xFF, 0x77, 0x77}, {0xFF, 0x88, 0x00},
{0xFF, 0xFF, 0x00}, {0x00, 0xFF, 0x00}, {0xFF, 0x00, 0x77}, {0x00, 0xBB, 0xFF},
{0xFF, 0xAA, 0x88}, {0xAA, 0xAA, 0xDD}, {0x88, 0x88, 0xBB}, {0x88, 0x00, 0xFF},
{0xFF, 0xAA, 0x00}, {0x00, 0xBB, 0x00}, {0x00, 0x00, 0x00}, {0xFF, 0xFF, 0xFF}
};

RGB BoblBobl_Colours_4[] = {
{0x00, 0x00, 0x00}, {0xAA, 0xAA, 0x88}, {0x77, 0x55, 0x55}, {0x00, 0x00, 0x00},
{0x00, 0xBB, 0x00}, {0xCC, 0xCC, 0xAA}, {0xFF, 0x00, 0x77}, {0xAA, 0x77, 0x44},
{0x88, 0x88, 0x66}, {0xCC, 0x88, 0x55}, {0xEE, 0xAA, 0x66}, {0x00, 0x00, 0x00},
{0xFF, 0xFF, 0xFF}, {0xFF, 0x00, 0x00}, {0xFF, 0xFF, 0x00}, {0x00, 0x00, 0x00}
};

RGB BoblBobl_Colours_5[] = {
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00},
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00},
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00},
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0xBB, 0xFF}, {0x00, 0x00, 0x00}
};

RGB BoblBobl_Colours_6[] = {
{0x00, 0x00, 0x00}, {0xDD, 0x44, 0x00}, {0xFF, 0x77, 0x77}, {0xFF, 0x88, 0x00},
{0xFF, 0xFF, 0x00}, {0x00, 0xCC, 0xFF}, {0xFF, 0x00, 0x77}, {0x00, 0xBB, 0xFF},
{0xFF, 0xAA, 0x88}, {0xAA, 0xAA, 0xDD}, {0x88, 0x88, 0xBB}, {0x88, 0x00, 0xFF},
{0xFF, 0xAA, 0x00}, {0x00, 0xAA, 0xFF}, {0x00, 0x00, 0x00}, {0xFF, 0xFF, 0xFF}
};

RGB BoblBobl_Colours_7[] = { //
{0x00, 0x00, 0x00}, {0xDD, 0x44, 0x00}, {0xFF, 0x77, 0x77}, {0xFF, 0x88, 0x00},
{0xFF, 0xFF, 0x00}, {0x00, 0xFF, 0x00}, {0xFF, 0x00, 0x77}, {0x00, 0xBB, 0xFF},
{0x00, 0x99, 0xFF}, {0x44, 0x00, 0x00}, {0x99, 0x00, 0x00}, {0x00, 0x00, 0xFF},
{0x66, 0x00, 0x00}, {0x00, 0xBB, 0x00}, {0x00, 0x00, 0x00}, {0xFF, 0xFF, 0xFF}
};

RGB BoblBobl_Colours_8[] = { // bob?
{0x00, 0x00, 0x00}, {0xDD, 0x44, 0x00}, {0xFF, 0x77, 0x77}, {0xFF, 0x88, 0x00},
{0x00, 0xFF, 0xFF}, {0x00, 0xAA, 0xFF}, {0xFF, 0x00, 0x77}, {0x00, 0xBB, 0xFF},
{0x00, 0x99, 0xFF}, {0x44, 0x00, 0x00}, {0x99, 0x00, 0x00}, {0x00, 0x00, 0xFF},
{0x66, 0x00, 0x00}, {0x00, 0x88, 0xFF}, {0x00, 0x00, 0x00}, {0xFF, 0xFF, 0xFF}
};

RGB BoblBobl_Colours_9[] = {
{0x00, 0x00, 0x00}, {0xDD, 0x44, 0x00}, {0xFF, 0x99, 0x99}, {0xFF, 0x88, 0x00},
{0xFF, 0xFF, 0x00}, {0xFF, 0x00, 0x00}, {0xFF, 0x00, 0x77}, {0x00, 0xCC, 0xFF},
{0x00, 0x99, 0xFF}, {0xAA, 0xAA, 0xDD}, {0x88, 0x88, 0xBB}, {0x88, 0x00, 0xFF},
{0xFF, 0xAA, 0x00}, {0xFF, 0x77, 0x77}, {0x00, 0x00, 0x00}, {0xFF, 0xFF, 0xFF}
};

RGB BoblBobl_Colours_a[] = {
{0x00, 0x00, 0x00}, {0xDD, 0x44, 0x00}, {0x00, 0xFF, 0xFF}, {0xFF, 0x88, 0x00},
{0xFF, 0xFF, 0x00}, {0x00, 0x88, 0xFF}, {0x88, 0x00, 0xFF}, {0x00, 0xCC, 0xFF},
{0x00, 0x99, 0xFF}, {0xAA, 0xAA, 0xDD}, {0x88, 0x88, 0xBB}, {0x88, 0x00, 0xFF},
{0xFF, 0xAA, 0x00}, {0x00, 0xDD, 0xFF}, {0x00, 0x00, 0x00}, {0xFF, 0xFF, 0xFF}
};

RGB BoblBobl_Colours_b[] = {
{0x00, 0x00, 0x00}, {0xDD, 0x44, 0x00}, {0xFF, 0x77, 0x77}, {0xFF, 0x88, 0x00},
{0xFF, 0xAA, 0x00}, {0xFF, 0x88, 0x00}, {0xFF, 0x00, 0x77}, {0x00, 0xBB, 0xFF},
{0x00, 0x99, 0xFF}, {0xAA, 0xAA, 0xDD}, {0x88, 0x88, 0xBB}, {0x88, 0x00, 0xFF},
{0xFF, 0xAA, 0xAA}, {0x00, 0xBB, 0x00}, {0x00, 0x00, 0x00}, {0xFF, 0xFF, 0xFF}
};

RGB BoblBobl_Colours_c[] = {
{0x00, 0x00, 0x00}, {0xDD, 0x44, 0x00}, {0xFF, 0xAA, 0x88}, {0xFF, 0x88, 0x00},
{0xFF, 0xFF, 0x00}, {0x00, 0x88, 0x00}, {0xFF, 0x00, 0x77}, {0x00, 0xCC, 0xFF},
{0x00, 0x99, 0xFF}, {0xAA, 0xAA, 0xDD}, {0x88, 0x88, 0xBB}, {0x88, 0x00, 0xFF},
{0xFF, 0xAA, 0x00}, {0x00, 0xDD, 0x00}, {0x00, 0x00, 0x00}, {0xFF, 0xFF, 0xFF}
};

RGB BoblBobl_Colours_d[] = { //
{0x00, 0x00, 0x00}, {0xDD, 0x44, 0x00}, {0xFF, 0x77, 0x77}, {0xFF, 0x88, 0x00},
{0xFF, 0xFF, 0x00}, {0x00, 0xFF, 0x00}, {0xFF, 0x00, 0x77}, {0x00, 0xBB, 0xFF},
{0x00, 0x99, 0xFF}, {0xAA, 0xAA, 0xDD}, {0x77, 0x00, 0x88}, {0x88, 0x00, 0xFF},
{0xFF, 0xAA, 0xAA}, {0x00, 0xBB, 0x00}, {0x00, 0x00, 0x00}, {0xFF, 0xFF, 0xFF}
};

RGB BoblBobl_Colours_e[] = {
{0x00, 0x00, 0x00}, {0xBB, 0x22, 0x00}, {0xFF, 0x77, 0x00}, {0xFF, 0x99, 0x77},
{0xFF, 0xDD, 0x88}, {0x88, 0x00, 0x00}, {0x66, 0x00, 0x00}, {0xFF, 0x00, 0x00},
{0x88, 0x00, 0x00}, {0xAA, 0xAA, 0xDD}, {0x88, 0x88, 0xBB}, {0x66, 0x66, 0x88},
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}
};

RGB BoblBobl_Colours_f[] = {
{0x00, 0x00, 0x00}, {0x66, 0x66, 0x99}, {0x88, 0x88, 0xBB}, {0xAA, 0xAA, 0xDD},
{0xFF, 0xFF, 0xFF}, {0x66, 0x66, 0x88}, {0x44, 0x55, 0x77}, {0xFF, 0x00, 0x00},
{0x88, 0x00, 0x00}, {0x66, 0x66, 0xFF}, {0x00, 0xBB, 0x00}, {0x00, 0xFF, 0xFF},
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}
};

RGB BoblBobl_Colours_10[] = {
{0x00, 0x00, 0x00}, {0x00, 0x99, 0xFF}, {0x00, 0xAA, 0xFF}, {0x00, 0xFF, 0xFF},
{0xFF, 0xFF, 0xFF}, {0x66, 0x66, 0xAA}, {0x55, 0x55, 0x77}, {0x66, 0x66, 0xFF},
{0x66, 0x66, 0x88}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00},
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}
};

RGB BoblBobl_Colours_11[] = {
{0x00, 0x00, 0x00}, {0x88, 0x88, 0x88}, {0x99, 0x99, 0x99}, {0xCC, 0xCC, 0xCC},
{0xFF, 0xFF, 0xFF}, {0x77, 0x77, 0x77}, {0x66, 0x66, 0x66}, {0xFF, 0x00, 0x00},
{0x88, 0x00, 0x00}, {0x00, 0x77, 0xFF}, {0x00, 0x00, 0x88}, {0x00, 0x00, 0x00},
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}
};

RGB BoblBobl_Colours_12[] = {
{0x00, 0x00, 0x00}, {0xFF, 0x00, 0x77}, {0xFF, 0xAA, 0x00}, {0xFF, 0xFF, 0x00},
{0xFF, 0xFF, 0xFF}, {0x88, 0x00, 0x00}, {0x66, 0x00, 0x00}, {0x00, 0xFF, 0x00},
{0x88, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00},
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}
};

RGB BoblBobl_Colours_13[] = {
{0x00, 0x00, 0x00}, {0xFF, 0x00, 0x99}, {0xFF, 0x77, 0xFF}, {0xFF, 0xAA, 0xFF},
{0xFF, 0xFF, 0xFF}, {0x88, 0x00, 0x44}, {0x77, 0x00, 0x00}, {0xFF, 0x00, 0x00},
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00},
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}
};

RGB BoblBobl_Colours_14[] = {
{0x00, 0x00, 0x00}, {0x88, 0x88, 0x55}, {0xAA, 0xAA, 0x77}, {0xCC, 0xCC, 0x88},
{0xFF, 0xFF, 0xBB}, {0x77, 0x66, 0x00}, {0x55, 0x55, 0x00}, {0xFF, 0x00, 0x00},
{0x00, 0x99, 0x00}, {0x00, 0xCC, 0x00}, {0x00, 0xFF, 0x00}, {0xFF, 0xFF, 0xFF},
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}
};

RGB BoblBobl_Colours_15[] = {
{0x00, 0x00, 0x00}, {0xBB, 0x88, 0x55}, {0xDD, 0xAA, 0x77}, {0xFF, 0xCC, 0x88},
{0xFF, 0xFF, 0xCC}, {0x77, 0x66, 0x00}, {0x55, 0x55, 0x00}, {0xFF, 0x00, 0x00},
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0xFF, 0xFF, 0xFF},
{0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}, {0x00, 0x00, 0x00}
};

struct PALETTE BoblBobl_Palettes[] =
{
    { 16, BoblBobl_Colours_0 },
    { 16, BoblBobl_Colours_1 },
    { 16, BoblBobl_Colours_2 },
    { 16, BoblBobl_Colours_3 },
    { 16, BoblBobl_Colours_4 },
    { 16, BoblBobl_Colours_5 },
    { 16, BoblBobl_Colours_6 },
    { 16, BoblBobl_Colours_7 },
    { 16, BoblBobl_Colours_8 },
    { 16, BoblBobl_Colours_9 },
    { 16, BoblBobl_Colours_a },
    { 16, BoblBobl_Colours_b },
    { 16, BoblBobl_Colours_c },
    { 16, BoblBobl_Colours_d },
    { 16, BoblBobl_Colours_e },
    { 16, BoblBobl_Colours_f },
    { 16, BoblBobl_Colours_10 },
    { 16, BoblBobl_Colours_11 },
    { 16, BoblBobl_Colours_12 },
    { 16, BoblBobl_Colours_13 },
    { 16, BoblBobl_Colours_14 },
    { 16, BoblBobl_Colours_15 }
};			      


struct GFXLAYOUT BoblBobl_charlayout =
{
	8,8,	/* the characters are 8x8 pixels */
	256*8,			/* 256 characters per bank,
				 * 8 banks per ROM pair */
	4,	/* 4 bits per pixel */
	{ 0, 4, 6*0x8000*8, 6*0x8000*8+4 },
	{ 3, 2, 1, 0, 11, 10, 9, 8 },
	{ 0*16, 1*16, 2*16, 3*16, 4*16, 5*16, 6*16, 7*16 },
	16*8	/* every char takes 16 bytes in two ROMs */
};

// this view of the graphics defines them as 16x16 blocks.
// it looks good for most of the graphics, but is clearly wrong for some
// of them, so I've left the original 8x8 definition above, too
//
// Chris Moore - chris.moore@writeme.com - 11 Nov 97
//
struct GFXLAYOUT BoblBobl_charlayout2 =
{
	16,16,	/* the characters are 8x8 pixels */
	64*8,			/* 64 characters per bank,
				 * 8 banks per ROM pair */
	4,	/* 4 bits per pixel */
	{ 0, 4, 6*0x8000*8, 6*0x8000*8+4 },

	{ 3, 2, 1, 0, 11, 10, 9, 8,
	  16*8 + 3,  16*8 + 2,  16*8 + 1, 16*8 + 0,
	  16*8 + 11, 16*8 + 10, 16*8 + 9, 16*8 + 8},

	{ 0*16, 1*16, 2*16, 3*16, 4*16, 5*16, 6*16, 7*16,
	  16*16, 17*16, 18*16, 19*16, 20*16, 21*16, 22*16, 23*16},

	16*8*4	/* every char takes 64 bytes in two ROMs */
};

struct GFXINFO BoblBobl_GfxInfo[] =
{
	/* read bank 0 as 8x8 characters */
	{ 0x0000, &BoblBobl_charlayout2 },
	/* same graphics, but read as 8x8 blocks */
	{ 0x0000, &BoblBobl_charlayout },

	/* read bank 1 as 8x8 characters */
	{ 0x8000, &BoblBobl_charlayout2 },
	/* same graphics, but read as 8x8 blocks */
	{ 0x8000, &BoblBobl_charlayout },

	/* read bank 2 as 8x8 characters */
	{ 0x10000, &BoblBobl_charlayout2 },
	/* same graphics, but read as 8x8 blocks */
	{ 0x10000, &BoblBobl_charlayout },

	/* read bank 3 as 8x8 characters */
	{ 0x18000, &BoblBobl_charlayout2 },
	/* same graphics, but read as 8x8 blocks */
	{ 0x18000, &BoblBobl_charlayout },

	/* read bank 4 as 8x8 characters */
	{ 0x20000, &BoblBobl_charlayout2 },
	/* same graphics, but read as 8x8 blocks */
	{ 0x20000, &BoblBobl_charlayout },

	/* read bank 5 as 8x8 characters */
	{ 0x28000, &BoblBobl_charlayout2 },
	/* same graphics, but read as 8x8 blocks */
	{ 0x28000, &BoblBobl_charlayout }
};


struct GAMEINFO BoblBobl =
{
   "Bobble-Bobble",
   12,
   BoblBobl_RomInfo,
   12,
   BoblBobl_GfxInfo,
   22,
   BoblBobl_Palettes,
   0
};



/////////////////////////////////////////////////////

struct GFXROMINFO c1942_RomInfo[] =
{
   { "1942\\1-f2.bin", 0x0000, 0x2000 },
	{ "1942\\2-a1.bin", 0x02000, 0x2000 },	/* tiles */
	{ "1942\\2-a3.bin", 0x04000, 0x2000 },
	{ "1942\\2-a5.bin", 0x06000, 0x2000 },
	{ "1942\\2-a2.bin", 0x08000, 0x2000 },
	{ "1942\\2-a4.bin", 0x0a000, 0x2000 },
	{ "1942\\2-a6.bin", 0x0c000, 0x2000 },
	{ "1942\\2-l1.bin", 0x0e000, 0x4000 },	/* sprites */
	{ "1942\\2-n1.bin", 0x12000, 0x4000 },
	{ "1942\\2-l2.bin", 0x16000, 0x4000 },
	{ "1942\\2-n2.bin", 0x1a000, 0x4000 }
};

RGB c1942_Colours[] =
{
   {0x00, 0x00, 0x00},
   {0x30, 0x30, 0x30},
   {0x25, 0x25, 0x25},
   {0x20, 0x20, 0x20},
   {0x15, 0x15, 0x15},
   {0x10, 0x10, 0x10},
   {0x30, 0x30, 0x30},
   {0x25, 0x25, 0x25},
   {0x20, 0x20, 0x20},
   {0x15, 0x15, 0x15},
   {0x10, 0x10, 0x10},
   {0x30, 0x30, 0x00},
   {0x30, 0x15, 0x00},
   {0x30, 0x00, 0x00},
   {0x15, 0x00, 0x00},
   {0x05, 0x00, 0x00}
};

RGB c1942_Colours2a[] =
{
	{0x00, 0x00, 0x00},
	{0x00, 0x51, 0x00},
	{0x00, 0x8f, 0x00},
	{0x43, 0x62, 0x00},
	{0x62, 0x51, 0x43},
	{0x70, 0x62, 0x51},
	{0x51, 0x43, 0x2d},
	{0x8f, 0x70, 0x62}
};

RGB c1942_Colours2b[] =
{
	{0x00, 0x00, 0x00},
	{0x00, 0x51, 0x00},
	{0x00, 0x8f, 0x00},
	{0x43, 0x62, 0x00},
	{0x62, 0x51, 0x43},
	{0x70, 0x62, 0x51},
	{0x51, 0x51, 0x51},
	{0x8f, 0x70, 0x62}
};

RGB c1942_Colours2c[] =
{
	{0x00, 0x00, 0x00},
	{0x9d, 0x9d, 0x9d},
	{0x8f, 0x8f, 0x8f},
	{0x62, 0x70, 0x70},
	{0x51, 0x62, 0x62},
	{0x43, 0x51, 0x51},
	{0x00, 0x51, 0x8f},
	{0x00, 0x43, 0x70}
};

RGB c1942_Colours2d[] =
{
	{0x00, 0x00, 0x00},
	{0x00, 0x51, 0x00},
	{0x00, 0x8f, 0x00},
	{0x70, 0x62, 0x51},
	{0x62, 0x51, 0x43},
	{0x70, 0x62, 0x51},
	{0x51, 0x43, 0x2d},
	{0x8f, 0x70, 0x62}
};

RGB c1942_Colours3[] =
{
	{0x00, 0x00, 0x00},
	{0x8f, 0xae, 0xe0},
	{0x51, 0x9d, 0xbc},
	{0xbc, 0xbc, 0xbc}
};

struct PALETTE c1942_Palettes[] =
{
    { 16, c1942_Colours },
    { 8, c1942_Colours2a },
    { 8, c1942_Colours2b },
    { 8, c1942_Colours2c },
    { 8, c1942_Colours2d },
    { 4, c1942_Colours3 }
};

struct GFXLAYOUT c1942_charlayout =
{
	8,8,	/* 8*8 characters */
	512,	/* 512 characters */
	2,	/* 2 bits per pixel */
	{ 4, 0 },
	{ 0*16, 1*16, 2*16, 3*16, 4*16, 5*16, 6*16, 7*16 },
	{ 8+3, 8+2, 8+1, 8+0, 3, 2, 1, 0 },
	16*8	/* every char takes 16 consecutive bytes */
};

struct GFXLAYOUT c1942_tilelayout =
{
	16,16,	/* 16*16 tiles */
	256,	/* 256 tiles */
	3,	/* 3 bits per pixel */
	{ 0, 0x2000*8, 0x4000*8 },	/* the bitplanes are separated */
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8,
			8*8, 9*8, 10*8, 11*8, 12*8, 13*8, 14*8, 15*8 },
	{ 16*8+7, 16*8+6, 16*8+5, 16*8+4, 16*8+3, 16*8+2, 16*8+1, 16*8+0,
			7, 6, 5, 4, 3, 2, 1, 0 },
	32*8	/* every tile takes 32 consecutive bytes */
};

struct GFXLAYOUT c1942_spritelayout =
{
	16,16,	/* 16*16 sprites */
	128,	/* 128 sprites */
	4,	/* 4 bits per pixel */
	{ 0x4000*8+4, 0x4000*8+0, 4, 0 },
	{ 0*16, 1*16, 2*16, 3*16, 4*16, 5*16, 6*16, 7*16,
			8*16, 9*16, 10*16, 11*16, 12*16, 13*16, 14*16, 15*16 },
	{ 33*8+3, 33*8+2, 33*8+1, 33*8+0, 32*8+3, 32*8+2, 32*8+1, 32*8+0,
			8+3, 8+2, 8+1, 8+0, 3, 2, 1, 0 },
	64*8	/* every sprite takes 64 consecutive bytes */
};

struct GFXINFO c1942_GfxInfo[] =
{
	{ 0x00000, &c1942_charlayout },
	{ 0x02000, &c1942_tilelayout },
	{ 0x08000, &c1942_tilelayout },
	{ 0x0e000, &c1942_spritelayout },
	{ 0x16000, &c1942_spritelayout },
	{ 0x10000, &c1942_spritelayout },
	{ 0x18000, &c1942_spritelayout }
};


struct GAMEINFO c1942 =
{
   "1942",
   11,
   c1942_RomInfo,
   7,
   c1942_GfxInfo,
   6,
   c1942_Palettes,
   0
};



/////////////////////////////////////////////////////

struct GFXROMINFO Bombjack_RomInfo[] =
{
   { "bombjack\\03_e08t.bin", 0x0000, 0x1000 },
   { "bombjack\\04_h08t.bin", 0x1000, 0x1000 },
   { "bombjack\\05_k08t.bin", 0x2000, 0x1000 },
	{ "bombjack\\06_l08t.bin", 0x3000, 0x2000 }, /* tiles */
	{ "bombjack\\07_n08t.bin", 0x5000, 0x2000 },
	{ "bombjack\\08_r08t.bin", 0x7000, 0x2000 },
	{ "bombjack\\16_m07b.bin", 0x9000, 0x2000 }, /* sprites */
	{ "bombjack\\15_l07b.bin", 0xb000, 0x2000 },
	{ "bombjack\\14_j07b.bin", 0xd000, 0x2000 }
};

RGB Bombjack_Colours[] =
{
   {0x00, 0x00, 0x00},
   {0xFF, 0xFF, 0xFF},
   {0x00, 0xBB, 0x00},
   {0xFF, 0xAA, 0x00},
   {0x88, 0x00, 0xFF},
   {0x88, 0x88, 0xBB},
   {0xAA, 0xAA, 0xDD},
   {0xFF, 0xAA, 0x88}
};

struct PALETTE Bombjack_Palettes[] =
{
    { 8, Bombjack_Colours }
};

struct GFXLAYOUT Bombjack_charlayout1 =
{
	8,8,	/* 8*8 characters */
	512,	/* 512 characters */
	3,	/* 3 bits per pixel */
	{ 0, 512*8*8, 2*512*8*8 },	/* the bitplanes are separated */
	{ 7*8, 6*8, 5*8, 4*8, 3*8, 2*8, 1*8, 0*8 },
	{ 0, 1, 2, 3, 4, 5, 6, 7 },	/* pretty straightforward layout */
	8*8	/* every char takes 8 consecutive bytes */
};

struct GFXLAYOUT Bombjack_charlayout2 =
{
	16,16,	/* 16*16 characters */
	256,	/* 256 characters */
	3,	/* 3 bits per pixel */
	{ 0, 1024*8*8, 2*1024*8*8 },	/* the bitplanes are separated */
	{ 23*8, 22*8, 21*8, 20*8, 19*8, 18*8, 17*8, 16*8,
			7*8, 6*8, 5*8, 4*8, 3*8, 2*8, 1*8, 0*8 },
	{ 0, 1, 2, 3, 4, 5, 6, 7,	/* pretty straightforward layout */
			8*8+0, 8*8+1, 8*8+2, 8*8+3, 8*8+4, 8*8+5, 8*8+6, 8*8+7 },
	32*8	/* every character takes 32 consecutive bytes */
};

struct GFXLAYOUT Bombjack_spritelayout1 =
{
	16,16,	/* 16*16 sprites */
	128,	/* 128 sprites */
	3,	/* 3 bits per pixel */
	{ 0, 1024*8*8, 2*1024*8*8 },	/* the bitplanes are separated */
	{ 23*8, 22*8, 21*8, 20*8, 19*8, 18*8, 17*8, 16*8,
			7*8, 6*8, 5*8, 4*8, 3*8, 2*8, 1*8, 0*8 },
	{ 0, 1, 2, 3, 4, 5, 6, 7,	/* pretty straightforward layout */
			8*8+0, 8*8+1, 8*8+2, 8*8+3, 8*8+4, 8*8+5, 8*8+6, 8*8+7 },
	32*8	/* every sprite takes 32 consecutive bytes */
};

struct GFXLAYOUT Bombjack_spritelayout2 =
{
	32,32,	/* 32*32 sprites */
	32,	/* 32 sprites */
	3,	/* 3 bits per pixel */
	{ 0, 1024*8*8, 2*1024*8*8 },	/* the bitplanes are separated */
	{ 87*8, 86*8, 85*8, 84*8, 83*8, 82*8, 81*8, 80*8,
			71*8, 70*8, 69*8, 68*8, 67*8, 66*8, 65*8, 64*8,
			23*8, 22*8, 21*8, 20*8, 19*8, 18*8, 17*8, 16*8,
			7*8, 6*8, 5*8, 4*8, 3*8, 2*8, 1*8, 0*8 },
	{ 0, 1, 2, 3, 4, 5, 6, 7,	/* pretty straightforward layout */
			8*8+0, 8*8+1, 8*8+2, 8*8+3, 8*8+4, 8*8+5, 8*8+6, 8*8+7,
			32*8+0, 32*8+1, 32*8+2, 32*8+3, 32*8+4, 32*8+5, 32*8+6, 32*8+7,
			40*8+0, 40*8+1, 40*8+2, 40*8+3, 40*8+4, 40*8+5, 40*8+6, 40*8+7 },
	128*8	/* every sprite takes 128 consecutive bytes */
};

struct GFXINFO Bombjack_GfxInfo[] =
{
	{ 0x0000, &Bombjack_charlayout1 },	/* characters */
	{ 0x3000, &Bombjack_charlayout2 },	/* background tiles */
	{ 0x9000, &Bombjack_spritelayout1 },	/* normal sprites */
	{ 0xa000, &Bombjack_spritelayout2 }	 /* large sprites */
};

struct GAMEINFO Bombjack =
{
   "Bomb Jack",
   9,
   Bombjack_RomInfo,
	4,
	Bombjack_GfxInfo,
   1,
   Bombjack_Palettes,
   0
};
