#include <stdio.h>
#include <dir.h>

typedef struct
   {
      short int game;
      char rom[13];
      unsigned int crc32;
      unsigned int crcs[6];
      int size;
   } ex_romid_t;

int checkfile(char *fn)
{
   struct ffblk f;
   int st = findfirst(fn, &f, FA_ARCH|FA_DIREC|FA_RDONLY);
   if (st) return -1;
   return f.ff_attrib;
};

int is_directory(char *fn)
{
   int a = checkfile(fn);
   if ((a!=-1)&&(a&FA_DIREC)) return 1;
   return 0;
};

void upper_case(char *str)
{
   int i, l = strlen(str);
   for (i=0;i!=l;i++) if ((str[i]>='a')&&(str[i]<='z')) str[i]-=32;
};

void upper_case_2(char *str)
{
   int i, l = strlen(str);
   for (i=0;i!=l;i++) {
      if ((str[i]>='a')&&(str[i]<='z')) str[i]-=32;
      if (str[i] == '_') str[i] = ' ';
   };
};
/*
int get_file_size(char *fn)
{
   struct find_t f;
   if (_dos_findfirst(fn, _A_NORMAL|_A_RDONLY, &f)) return -1;
   return f.size;
};
*/
int get_file_size(char *fn)
{
   struct ffblk f;
   if (findfirst(fn, &f, FA_ARCH|FA_RDONLY)) return -1;
   return f.ff_fsize;
};

void get_zipfilename(char *s, char *d)
{
   int i, ss, ee = strlen(s);
   while (s[ee]!='.') ee--;
   ss = ee - 1;
   while ((s[ss]!='/')&&(s[ss]!='\\')&&(ss)) ss--;
   if ((s[ss]=='/')||(s[ss]=='\\')) ss++;
   for (i=0;i!=(ee-ss);i++) d[i] = s[ss + i];
   d[i] = 0;
};

void get_dirname(char *s, char *d)
{
   int i, ss, ee = strlen(s);
   while ((s[ee]!='/')&&(s[ee]!='\\')) ee--;
   ss = ee - 1;
   while ((s[ss]!='/')&&(s[ss]!='\\')&&(ss)) ss--;
   if ((s[ss]=='/')||(s[ss]=='\\')) ss++;
   for (i=0;i!=(ee-ss);i++) d[i] = s[ss + i];
   d[i] = 0;
};

void get_filename(char *s, char *d)
{
   int i, ss, ee = strlen(s);
   ss = ee - 1;
   while ((s[ss]!='/')&&(s[ss]!='\\')&&(ss)) ss--;
   if ((s[ss]=='/')||(s[ss]=='\\')) ss++;
   for (i=0;i!=(ee-ss);i++) d[i] = s[ss + i];
   d[i] = 0;
};

int hex2int(char *crcstr)
{
   int s = 0, i, v = 0, m = 1;
   char d;
   do {
      s++;
   } while ((crcstr[s]!=0)&&(crcstr[s]!=' '));
   s--;
   for (i=s;i>=0;i--) {
      if (crcstr[i]>='a') crcstr[i]-=32;
      d = crcstr[i];
      if ((d>='0') && (d<='9')) v+=m*(int)(d-'0');
      if ((d>='A') && (d<='F')) v+=m*(10+(int)(d-'A'));
      m = m * 16;
   };
   return v;
};

