@echo off

  REM **************************************************************************
  REM Progams always terminate with an exitcode.  The exitcode will depend on
  REM the termination purpose. At this point the following codes are defined:
  REM
  REM 0  EXIT_NORMAL                (e.g. $ exit 0  = program terminated)
  REM 1  EXIT_ON_ERRORS             (e.g. $ exit 1  = program aborted)
  REM
  REM The exitcode can be specified as a parameter to the 'exit' command:
  REM
  REM $ exit 12                     ;* terminate program  and return exitcode 12
  REM
  REM The user or programmer may simply utilize  this exitcode for writing batch
  REM files  which allows special handling (gosub/gotos/chain/fork)  or re-start
  REM of the program after termination.
  REM
  REM If you start the program from within a procedure file (batch) the exitcode
  REM can be analyzed with the 'if errorlevel==' command. We highly recommend to
  REM refer to the MS-DOS manual for further information on writing  batch files
  REM and to get familiar with this special command and errorlevel handling.
  REM
  REM OS9MAX allows to write a procedure (batch) file from within the program by
  REM means of the 'mkbatch' command. Please refer to the online help. This
  REM command allows to execute commands (DOS SHELL) from OS9MAX:
  REM
  REM 1. Write a procedure file (mkbatch)
  REM 2. Exit with errorlevel (will jump to the correct item in this file)
  REM 3. Execute procedure file
  REM 4. Return (restart OS9MAX)
  REM
  REM Important Notice
  REM ----------------
  REM This is an example, please customize the commandline (drv/fmt). If you
  REM have any questions regarding this part of the documentation please send
  REM us a fax. As always : your suggestions are highly welcome. If you have
  REM any needs which are not covered by this state of implementation call us!
  REM
  REM **************************************************************************

: START

  REM OS9MAX A: 38U0 /m0 'cat'
  REM OS9MAX A: 38U0 /m0 SCRIPT.CMD
      OS9MAX A: 38U0 /m0

      if errorlevel==4 goto INV
      if errorlevel==3 goto E03
      if errorlevel==2 goto E02
      if errorlevel==1 goto E01
      if errorlevel==0 goto E00

:E00
      echo *** Normal Termination
      goto EXIT

:E01
      echo *** Error Termination
      goto EXIT

:E02
      echo *** Start Subprocess and Return
      REM The following file may be created from within OS9MAX
      REM i.e.: '$ mkbatch child.bat cmd1 cmd2...'

      call child.bat
      goto START

:E03
      echo *** Execute Command and Return
      dir
      goto START

:INV
      echo *** Unknown Errorlevel
      goto EXIT

:EXIT

