
/*
  The pragma pack tells the compiler to pack the structures without any
  extra padding.  This is needed so the OS9 structures will be read
  properly.  Actually, only the os9.h header needs this.
*/
#pragma pack(1)

/*
  These are the data structures that OS9 uses.
  Each OS9 version is followed by the PC version.  The PC version is
  all that the higher level routines see.
  The PC versions differ in byte ordering of integers, strings, and
  LSN's are converted to byte offset's.  This also means that the
  ------------------------------------
  size of the the PC versions are larger, so don't do any SIZEOF on
  them when you mean to do it for the OS9 versions.
*/

/*
  An OS9 directory entry
*/
struct s_dirent {
     char dir_name[29];
     unsigned char dir_addr[3];
     };

/*
  The PC version of the OS9 directory entry.
*/
struct DirEntry {
     char dir_name[30];  /* 1 more for null */
     unsigned long dir_addr;
     };

/*
  The OS9 segment list for file descriptors
*/
struct s_seg {
     unsigned char     addr[3];
     unsigned size;
     };

/*
  The PC version of the segment list for file descriptors
*/
struct SegList {
     unsigned long baddr;  /* byte pos addr */
     unsigned long bsize;  /* size in bytes */
     unsigned long saddr;  /* sector number */
     unsigned long ssize;  /* size in sectors */
     };

/*
  The OS9 descriptor for each file.  Size: 1 block = 256 bytes
*/
struct s_filedesc {
     char         fd_att;
     unsigned     fd_own;
     char         fd_date[5];
     char         fd_link;
     long         fd_fsize;
     unsigned char         fd_dcr[3];
     struct s_seg fd_seg[48];
     };

/*
  The PC version of the descriptor for each file.
*/
struct FileDesc {
     char           fd_att;
     unsigned       fd_own;
     char           fd_date[5];
     char           fd_link;
     unsigned long  fd_fsize;
     unsigned char  fd_dcr[3];
     struct SegList fd_seg[48];
/* I've added a few pieces of info here */
     int           activeseg; /* which segment are we doing? */
     unsigned long curpos;    /* the next byte possition */
     unsigned long segbytes;  /* how many bytes are left in the segment? */
     unsigned long bytesleft; /* how many bytes left in the file? */
     unsigned long homeptr;   /* Where the fdesc goes on the disk */
     };

typedef struct FileDesc OS9FILE;

/*
  OS9 Identification Sector (LSN 0) for the disk
*/
struct s_ddsect {
     unsigned char      dd_tot[3];
     char      dd_tks;
     unsigned  dd_map;
     unsigned  dd_bit;
     unsigned char      dd_dir[3];
     unsigned  dd_own;
     char      dd_att;
     unsigned  dd_dsk;
     char      dd_fmt;
     unsigned  dd_spt;
     unsigned  dd_res;
     unsigned char      dd_bt[3];
     unsigned  dd_bsz;
     char      dd_date[5];
     char      dd_name[32];
     };

/*
  PC version of the OS9 Identification Sector (LSN 0) for the disk
*/
struct DDSect {
     long      dd_tot;
     int       dd_tks;
     unsigned  dd_map;
     unsigned  dd_bit;
     long      dd_dir;
     unsigned  dd_own;
     char      dd_att;
     unsigned  dd_dsk;
     char      dd_fmt;
     unsigned  dd_spt;
     unsigned  dd_res;
     long      dd_bt;
     unsigned  dd_bsz;
     char      dd_date[5];
     char      dd_name[33];  /* 1 more for null */
/* I've added a few extra pieces of info here for convenience. */
     int       sides;        /* how many sides does it have 1 or 2? */
     long      tracks;       /* total number of tracks */
     int       sectors;      /* sectors per track */
     int       cylsectors;   /* sectors per cylinders (allowing for */
                             /* multiple heads.) */
     unsigned long bytesused; /* bytes (rounded to sectors) used */
     unsigned long bytesfree; /* number of bytes free */
     unsigned long sectorsused;
     unsigned long sectorsfree;
     };

/*
  The user options and additional info the program needs to know to
  do what the user wants.
*/
struct options
  {int ascii;
   int drivenum;
   int virtdisk;
   int dir;
   int get;
   int put;
   int fulldir;
   int makevirt;
   int writevirt;
   int debug;
   char pathname[PATHLEN];    /* directory path */
   char filename[PATHLEN];    /* the file name */
   char vdiskname[PATHLEN];   /* the path name to the virtual disk file */
   char pcfilename[PATHLEN];
   FILE *pcvirtfile;
   FILE *pcfile;
   OS9FILE *os9file;
  } options;


