/*
  Copy files to/from OS9/PC disks.
*/

char *Date="July 13, 1995";
char *Version="V2.06";

/*
  Carey Bloodworth
  1601 North Hills Blvd.
  Van Buren, AR 72956-2152
*/

/*
#define DEBUG2 1
#define DEBUG  1
*/

extern unsigned _stklen=0x4000;
/* Set the stack size to 16k */

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <errno.h>
#include <dos.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <io.h>
#include <time.h>
#include <conio.h>
#include <bios.h>

#define TRUE 1
#define FALSE 0

/* The maximum possible size of sector that MS-DOS can handle */
#define          MaxSectSize  1024

/* String sizes */
#define          STRLEN       64
#define          PATHLEN      128

#include "os9.h"
#include "proto.h"

struct DDSect    diskinfo;      /* the LSN 0 and other info */
struct DirEntry  rootdirentry;  /* make up a dir entry for the root dir */
OS9FILE          dirdesc;       /* the fdesc of the file/dir you want */
unsigned char   *dam;           /* Disk Allocation Map */
unsigned int     damsize;       /* byte size of DAM */
int              SectorSize;    /* size (bytes) of the sectors */
int              DosBPS;        /* DOS's Bytes per Sector val # */


#include "args.c"
#include "convert.c"
#include "dodir.c"
#include "doget.c"
#include "doput.c"
#include "dovirt.c"
#include "lib.c"
#include "lowio.c"
#include "os9disk.c"
#include "os9file.c"

void InitVars(void)
{int x;
/*
  preset it for standard CoCo disks.
  It doesn't really matter what we set it, just so long as we can
  read the first sector on track 0, head 0.  (LSN0).
*/  
diskinfo.sides=1;
diskinfo.tracks=35;
diskinfo.sectors=18;
diskinfo.cylsectors=18;

SectorSize=256;
DosBPS=1; /* 0=128, 1=256, 2=512, 3=1024 */

options.ascii=FALSE;
options.virtdisk=FALSE;
options.dir=FALSE;;
options.get=FALSE;
options.put=FALSE;
options.fulldir=FALSE;
options.makevirt=FALSE;
options.writevirt=FALSE;
options.drivenum=-1;
/* Clear the pathname & filename, to the very last byte */
for (x=0;x<PATHLEN;x++) 
   {options.pathname[x]=options.vdiskname[x]=0;
    options.pcfilename[x]=options.filename[x]=0;
   }
options.pcfile=NULL;
options.pcvirtfile=NULL;
options.debug=0;
#ifdef DEBUG
options.debug=1;
#endif
#ifdef DEBUG2
options.debug=2;
#endif

}

void main(int argc,char *argv[])
{
printf("OS9 <-> PC file converter, %s\n",Version);
printf("(C)opyright by Carey Bloodworth, %s\n\n",Date);

InitVars();

ParseArgs(argc,argv);

OpenOS9Disk();

printf("Diskname: %s\n",diskinfo.dd_name);
ShowSize();
printf("Sectors used: %lu Sectors free: %lu\n",
       diskinfo.sectorsused,diskinfo.sectorsfree);
printf("Bytes used: %lu Bytes free: %lu\n",
       diskinfo.bytesused,diskinfo.bytesfree);


if (options.debug)
  {printf("Total sectors: %lu ",diskinfo.dd_tot);
   printf("Track size: %d, Sectors/track %d ",
          diskinfo.dd_tks,diskinfo.dd_spt);
   printf("#Tracks: %d\n",(int)diskinfo.dd_tot / diskinfo.dd_spt);
   printf("Allocation map size %d, sectors/cluster %d ",
          diskinfo.dd_map,diskinfo.dd_bit);
   printf("Root DIR pos: %lu\n",diskinfo.dd_dir);
   printf("Disk ID: $%04x, Disk attrib $%02x, Owner %d\n",
          diskinfo.dd_dsk,diskinfo.dd_att,diskinfo.dd_own);
   printf("Format: %d sides: %d ",diskinfo.dd_fmt,diskinfo.sides);
   printf("Boot strap POS %lu Size %u\n",diskinfo.dd_bt,diskinfo.dd_bsz);
   printf("Creation Date %d:%d:%d:%d:%d\n",
          diskinfo.dd_date[0],diskinfo.dd_date[1],diskinfo.dd_date[2],
          diskinfo.dd_date[3],diskinfo.dd_date[4]);
  }

dirdesc=OS9FOpen(WalkDirPath().dir_addr);  /* open the directory we want */

if (options.get)      DoGet(dirdesc);
else if (options.put) DoPut(dirdesc);
else if (options.dir) DoDir(dirdesc);
else if (options.makevirt) DoMakeVirt();
else if (options.writevirt) DoWriteVirt();


if (options.debug) printf("Program complete\n");

QuitProgram(EZERO);
}

