/*
  These routines are just misc. routines that don't fit into the
  other catagory modules.

  There are also some 'lower level' routines that are more 'libraryish'
  than any specific area.
*/


void QuitProgram(int error)
/*
  Quit the program.  This closes the OS9 disk, etc. and does anything
  else it needs to do before exiting, possibly with an error code.
*/
{
CloseOS9Disk();
/* ResetDisk(); */ /* Can't reset, because reset() might generate an error */
if (options.pcfile != NULL) fclose(options.pcfile);  /* might still be open */
exit(error);
}

int CmpStr(char * s1, char * s2)
{
while (tolower(*s1)==tolower(*s2))
  {if (tolower(*s1)==0) return TRUE;
   s1++;s2++;
  }
return FALSE;
}

int PeelPathName(char *FName)
/*
  Peel a filename off of the path/file name specified
*/
{char *cp,*path;
 int valid=FALSE;

/* Copy next file name to FName */
path=options.pathname;
while (TRUE)
  {if ( (*path == NULL) || (*path == '/') || (*path == '\\')) break;
   *FName++=*path++;
   valid=TRUE;
  }
*FName=NULL;

/* Now remove that part from the original path */
cp=options.pathname;
if (*path != NULL) path++; /* increment past the / or \ */
while (*path != NULL) *cp++ = *path++;
*cp=NULL;
return valid;
}


int GetNextSeg(OS9FILE *fd)
/*
  Internal routine.  Do not call.
  This just advances the segment pointer to the next segment.
  If there are no more segments, FALSE will be returned.
*/
{
if ( (fd->fd_seg[fd->activeseg].saddr == 0L)  &&
     (fd->fd_seg[fd->activeseg].ssize == 0L) )
   {
    fd->curpos   =0L;
    fd->segbytes =0L;
    fd->bytesleft=0L;
    return FALSE;
   }

if (fd->activeseg++ > 47)
  {fprintf(stderr,"Out of segments\n");
   QuitProgram(EINVDAT);
  }

fd->segbytes=fd->fd_seg[fd->activeseg].bsize;
fd->curpos  =fd->fd_seg[fd->activeseg].baddr;
return TRUE;
}

int BitCount(int n)
/* count bits set in an integer */
{unsigned int count=0;
while (n) {n ^= (n & -n);count++;}
return count;
}

unsigned long FirstBitClear(void)
/*
  find the first bit clear in the DAM.
*/
{unsigned int x;
unsigned int y,z;
x=0;y=0;
while (x < damsize)
  {if (dam[x] == 255) {x++;continue;}
   else break;
  }
if (x == damsize) return 0L;

z=dam[x];
while ((z & 0x80) == 0x80) {z<<=1;y++;}
return (unsigned long) x * 8L + y;
}

unsigned long AllocateSector(void)
{unsigned long lsn;
lsn=FirstBitClear();
SetDAMBit(lsn);
return lsn;
}

/* Note that the bit mask order is backwards from normal */
unsigned char bitmask[8]={128,64,32,16,8,4,2,1};

void SetDAMBit(unsigned long bit)
{
/* printf("DAM before: %u, byte %u\n",dam[bit >> 3],(bit >> 3)); */
dam[(int) bit >> 3] = dam[(int) bit >> 3] | bitmask[(int)bit & 7];
/* printf("DAM after: %u\n",dam[bit >> 3]); */
}

void DumpSeg(OS9FILE *fd)
{int x;

printf("File is %lu bytes\n",fd->fd_fsize);
for (x=0;x<48;x++)
  {printf("Seg %2d Addr B%10lu S%8lu. Size B%10lu S%8lu\n",x,
          fd->fd_seg[x].baddr,
          fd->fd_seg[x].saddr,
          fd->fd_seg[x].bsize,
          fd->fd_seg[x].ssize);
   if ((fd->fd_seg[x].baddr == 0L) && (fd->fd_seg[x].bsize == 0L)) break;
  }
}

int FindLastUsedSeg(OS9FILE *fd)
{int x;
for (x=0;x<48;x++)
  if ((fd->fd_seg[x].bsize == 0L) && (fd->fd_seg[x].baddr == 0L)) break;

if (options.debug)
  {printf("seg #%d is last/free\n",x);}

if (x == 0) return -1;   /* no segments at all */
return x-1;              /* The one before the end segment */
}
  
unsigned long GetFileAllocSize(OS9FILE *fd)
/*
  Get a count of all the space allocated to a file (segments), not
  just what happens to be used.
*/
{unsigned long fz;int seg;

fz=0L;seg=0;

while (!( (fd->fd_seg[seg].saddr ==0L) && (fd->fd_seg[seg].ssize ==0L) ))
  {fz+=fd->fd_seg[seg].bsize;
   seg++;
  }
return fz;
}

int AddSector(OS9FILE *fd)
/*
  Add a sector to the segment list.
  Three conditions
  1: No segments used at all yet. (-1)
  2: The new sector fits onto the end of the last segment
  3: The new sector does not fit onto the end of the last segment.

  If it's condition 1 or 3, we have to set the pointer/addr to the new
  segment, in addition to the regular incrementing of size.
*/
{unsigned long lsn;int seg;
lsn=AllocateSector();
seg=FindLastUsedSeg(fd);

if (lsn == 0L)
  {
   if (options.debug) fprintf(stderr,"Disk FULL\n");
   return FALSE;
  }

if (options.debug) printf("Allocating sector %lu\n",lsn);

if ( (seg == -1) ||   /* condition 1 and 3 */
     ((fd->fd_seg[seg].saddr + fd->fd_seg[seg].ssize) != lsn ) )
  {seg++;                /* either way, we have to use the next seg. */
   if (options.debug) {printf("Have to start new seg %d\n",seg);}
   if (seg >= 48) return FALSE;
   fd->fd_seg[seg].baddr=lsn * SectorSize;
   fd->fd_seg[seg].saddr=lsn;
   if (seg == 0) fd->curpos=lsn * SectorSize;
  }

fd->fd_seg[seg].bsize+=SectorSize; /* increment the size of the segment */
fd->fd_seg[seg].ssize++;

fd->fd_fsize+=SectorSize;  /* Increment the file size. */

/* Clear next, unused sector */
seg++;
if (seg < 48)
  {fd->fd_seg[seg].bsize=0L;
   fd->fd_seg[seg].baddr=0L;
   fd->fd_seg[seg].ssize=0L;
   fd->fd_seg[seg].saddr=0L;
  }

return TRUE;
}

void *SafeMalloc(unsigned int bytes,char *funcname)
{void *buffer;
buffer=malloc(bytes);
if (buffer == NULL)
  {
   fprintf(stderr,"%s: Unable to allocate %u bytes for buffer\n",
           funcname,bytes);
   QuitProgram(ENOMEM);
  }
return buffer;
}

