/*
  I really, really don't like the way I handle virtual disks.  I've even
  thought about ripping it all out.  Sure would make some of the other
  stuff clearer.
  
  I have to do a bit of a kludge so that the prepdisk() and others will
  init from the right disk.

  In order to speed up the making & writing of virtual disks, I sort of
  have to violate one of my 'rules' and call Read/WriteTheDisk() directly
  instead of through the Read/WriteOS9Sector().  See, R/WTD() can
  handle multiple sectors while R/WOS() can't.  I could modify R/WOS() to
  do multiple sectors, but the changes would snowball all over the place
  and I don't want to do that.  It would also encourage others (or me)
  to try and do other readings & writings with multiple sectors when
  in fact, R/WTD() is just the biosdisk() call and can only handle
  multiple sectors when they are consecutive and on the same track & side.
*/


#define MAX(a,b) ((a)>(b)?(a):(b))


void DoMakeVirt(void)
/*
  Copy a OS9 disk into a 'virtual' disk.
*/
{unsigned long lsn;int cursorx,cursory;
unsigned char *buffer;
int sectors,tries,failed;
unsigned long track0;

OpenDestFile(options.filename);

sectors=MAX(diskinfo.sectors,diskinfo.dd_tks);
buffer=SafeMalloc(SectorSize*sectors,"MakeVirt");

printf("\n\n");  /* so we wont be printing on the last line of screen */
cursorx=wherex();cursory=wherey()-1;
lsn=0L;
track0=diskinfo.dd_tks*diskinfo.sides;

while (lsn < diskinfo.dd_tot)  /* Should I allow for clusters? */
  {if (lsn < track0) sectors=diskinfo.dd_tks;  /* Track 0 may have */
   else sectors=diskinfo.sectors;  /* a different num of sectors */

   gotoxy(cursorx,cursory);
   printf("Reading (virtual) lsn %lu-%lu   \n",lsn,lsn+sectors-1);

   tries=5;
   do {failed=!ReadTheDisk(lsn,sectors,buffer);
       if (failed) ResetDisk();
      } while ((tries--) && (failed));

   if (failed)
     {fprintf(stderr,"Error Reading the physical disk\n");
      QuitProgram(EFAULT);
     }

   if (fwrite(buffer,SectorSize,sectors,options.pcfile) != sectors)
      {fprintf(stderr,"Error creating the virtual disk, errno %d",errno);
       QuitProgram(errno);
      }

   lsn=lsn + sectors;
  }

fclose(options.pcfile);
options.pcfile=NULL;
free(buffer);
}


void DoWriteVirt(void)
/*
  Copy a 'virtual' disk onto a physical disk.

  The kludge here and in the args routine is so that PrepOS9Disk()
  will get the LSN0 from the virtual disk.  Now that we are here,
  we have to change it back over to the physical disk so it can write
  to it.  Kludge Kludge Kludge.
*/
{unsigned long lsn;int cursorx,cursory;
unsigned char *buffer;
int sectors,tries,failed;
unsigned long track0;

options.virtdisk=FALSE;     /* kludge */
fclose(options.pcvirtfile); /* kludge */
PrepOS9Disk();              /* kludge */

OpenSourceFile(options.filename);

sectors=MAX(diskinfo.sectors,diskinfo.dd_tks);
buffer=SafeMalloc(SectorSize*sectors,"MakeVirt");

printf("\n\n");  /* so we wont be printing on the last line of screen */
cursorx=wherex();cursory=wherey()-1;
lsn=0L;
track0=diskinfo.dd_tks*diskinfo.sides;

while (lsn < diskinfo.dd_tot)  /* Should I allow for clusters? */
  {if (lsn < track0) sectors=diskinfo.dd_tks;  /* Track 0 may have */
   else sectors=diskinfo.sectors;  /* a different num of sectors */

   gotoxy(cursorx,cursory);
   printf("Writing (virtual) lsn %lu-%lu   \n",lsn,lsn+sectors-1);

   if (fread(buffer,SectorSize,sectors,options.pcfile) != sectors)
      {fprintf(stderr,"Error creating the virtual disk");
       QuitProgram(errno);
      }

   tries=5;
   do {failed=!WriteTheDisk(lsn,sectors,buffer);
       if (failed) ResetDisk();
      } while ((tries--) && (failed));

   if (failed)
     {fprintf(stderr,"Error Writing the physical disk\n");
      QuitProgram(EFAULT);
     }

   lsn=lsn + sectors;
  }

fclose(options.pcfile);
options.pcfile=NULL;
free(buffer);
}


