
void DoGet(OS9FILE dir)
/*
  Copy a file from OS9 to PC
*/
{OS9FILE fd;struct DirEntry direntry;
 unsigned int bytesread;
 unsigned int byteswritten;
 char *buffer;


if (options.debug)
  {printf("Opening %s for binary write\n",options.filename);}

/* We're in the directory, now find the file. */

if (!SearchDir(dir,options.filename,&direntry))
  {fprintf(stderr,"File %s not found on OS9 disk\n",options.filename);
   QuitProgram(ENOFILE);
  }

fd=OS9FOpen(direntry.dir_addr);

/* Make sure we aren't trying to copy the directory itself! */
if (fd.fd_att & 0x80)
  {printf("You can't copy a directory\n");
   QuitProgram(EZERO);
  }

OpenDestFile(options.pcfilename);

/* Allocate memory for the buffer */
buffer=SafeMalloc(SectorSize*2,"DoGet");

while (TRUE)
   {bytesread=OS9FRead(&fd,buffer,SectorSize);

    if (options.debug) {printf("Bytes Read in DOGET: %d\n",bytesread);}

    if (bytesread == 0) break;
    if (options.ascii) bytesread=CvtBin2Asc(buffer,bytesread);
    byteswritten=fwrite(buffer,1,bytesread,options.pcfile);
    if (byteswritten != bytesread)
       {fprintf(stderr,"Write to PC file failed\n");
        QuitProgram(errno);
       }
   }

fclose(options.pcfile);
options.pcfile=NULL;
free(buffer);
}

void OpenDestFile(char *filename)
/*
  I may need to do a little file name conversion, but I'm not going
  to worry about that right now.
*/
{
options.pcfile=fopen(filename,"wb");
if (options.pcfile==NULL)
  {fprintf(stderr,"Unable to open %s for writing\n",filename);
   QuitProgram(errno);
  }
}

int CvtBin2Asc(char *buf, unsigned int bufsize)
/*
  Convert CR into CR/LF
  This routine assumes (ie. requires) that the buffer be twice
  the size of the 'bufsize' being passed.  This will allow enough
  space for the cr->cr/lf conversion.
*/
{unsigned int x,y;

/* Move the data up to the top */
for (x=0;x<bufsize;x++) buf[bufsize+x]=buf[x];

/* Now we have enough space to do the conversion */
y=0;
for (x=bufsize;x<bufsize*2;x++)
  {
   buf[y++]=buf[x];
   if (buf[x] == 0x0d) buf[y++]=0x0a;
  }

return y;
}

