/*
   This deals only with the conversion routines that convert
   the OS9 structures to PC version structures.

   You shouldn't need to call any of these yourself.
*/


long l3tol(unsigned char* ptr)
/*
  convert the OS9 3 byte long LSN into (C's long type) byte offset
*/
{long x=0L;
x=ptr[0];
x=x * 256L + ptr[1];
x=x * 256L + ptr[2];
return x;
}

void ltol3(unsigned char *ptr,unsigned long num)
/*
  Convert long into OS9's 3 byte long LSN
*/
{
/* printf("Entering ltol3 with %lu\n",num); */
ptr[2]=num % 256;num=num/256;
ptr[1]=num % 256;num=num/256;
ptr[0]=num % 256;num=num/256;
if (num != 0L)
  {fprintf(stderr,"LTOL3 failure.  %lu left over\n",num);
   QuitProgram(ERANGE);
  }
}

unsigned int IntegerOrder(unsigned int var)
/*
  This swaps the byte ordering for the PC's backward little endian
*/
{unsigned char *ptr=(unsigned char *)&var;
return ptr[0]*256+ptr[1];
}

unsigned long LongOrder(unsigned long var)
/*
  Swap the byte ordering of a LONG integer to PC's backward
  little endian nature.
*/
{unsigned long x;unsigned char *ptr=(unsigned char*) &var;
x=ptr[0];
x=x * 256L + ptr[1];
x=x * 256L + ptr[2];
x=x * 256L + ptr[3];
return x;
}

void CvtStrNull(char* fstr,char *tstr)
/*
  convert a high bit str to a null string
*/
{char c;
while (TRUE)
  {c=*fstr++;
  *tstr++=tolower(c & 0x7f);
  if ( (c== '\0') || ((c & 0x80) == 0x80) ) break;
  }
*tstr=NULL;
}

void CvtStrHigh(char* fstr,char *tstr)
/*
  convert a null terminated string to high bit set string
*/
{
while (*fstr)
  {*tstr=*fstr;fstr++;
   if (*fstr == NULL) *tstr = *tstr | 0x80;
   tstr++;
  }
}
/*
=================================================================
These are the routines that convert PC to OS9 structures
=================================================================
*/

struct s_dirent CvtDirEntry2OS9(struct DirEntry *PC)
{struct s_dirent OS9;
CvtStrHigh(PC->dir_name,OS9.dir_name);
ltol3(OS9.dir_addr,PC->dir_addr/SectorSize);
return OS9;
}

struct s_seg CvtSeg2OS9(struct SegList *PC)
{struct s_seg OS9;
ltol3(OS9.addr,PC->saddr);
OS9.size=IntegerOrder((int)PC->ssize);
return OS9;
}

struct s_filedesc CvtFDesc2OS9(OS9FILE *PC)
{int x;struct s_filedesc OS9;
OS9.fd_att=PC->fd_att;
OS9.fd_own=IntegerOrder(PC->fd_own);
memcpy(OS9.fd_date,PC->fd_date,5);
OS9.fd_link=PC->fd_link;
OS9.fd_fsize=LongOrder(PC->fd_fsize);
memcpy(OS9.fd_dcr,PC->fd_dcr,3);
for (x=0;x<48;x++) OS9.fd_seg[x]=CvtSeg2OS9(&PC->fd_seg[x]);
return OS9;
}


/*
=================================================================
These are the routines that convert OS9 to PC structures
=================================================================
*/

struct DirEntry CvtDirEntry2PC(struct s_dirent *OS9)
{struct DirEntry PC;
CvtStrNull(OS9->dir_name,PC.dir_name);
PC.dir_addr=l3tol(OS9->dir_addr)*SectorSize;  /* cvt to byte pos */
return PC;
}

struct SegList CvtSeg2PC(struct s_seg *OS9)
{struct SegList PC;
PC.saddr=l3tol(OS9->addr);
PC.ssize=IntegerOrder(OS9->size);
PC.baddr=PC.saddr*SectorSize;                 /* cvt to byte pos */  
PC.bsize=PC.ssize*SectorSize;                 /* cvt to byte pos */
return PC;
}

struct FileDesc CvtFDesc2PC(struct s_filedesc *OS9)
{int x;struct FileDesc PC;
PC.fd_att=OS9->fd_att;
PC.fd_own=IntegerOrder(OS9->fd_own);
memcpy(PC.fd_date,OS9->fd_date,5);
PC.fd_link=OS9->fd_link;
PC.fd_fsize=LongOrder(OS9->fd_fsize);
memcpy(PC.fd_dcr,OS9->fd_dcr,3);
for (x=0;x<48;x++) PC.fd_seg[x]=CvtSeg2PC(&OS9->fd_seg[x]);
OS9FSeek(&PC,0L);
return PC;
}

struct DDSect CvtDDSect(struct s_ddsect *OS9)
{struct DDSect PC;
PC.dd_tot=l3tol(OS9->dd_tot);
PC.dd_tks=OS9->dd_tks;
PC.dd_map=IntegerOrder(OS9->dd_map);
PC.dd_bit=IntegerOrder(OS9->dd_bit);
PC.dd_dir=l3tol(OS9->dd_dir)*SectorSize; /* cvt to byte pos */
PC.dd_own=IntegerOrder(OS9->dd_own);
PC.dd_att=OS9->dd_att;
PC.dd_dsk=IntegerOrder(OS9->dd_dsk);
PC.dd_fmt=OS9->dd_fmt;
PC.dd_spt=IntegerOrder(OS9->dd_spt);
PC.dd_res=OS9->dd_res;   /* reserved.  Not used.  No need to swap bytes */
PC.dd_bt=l3tol(OS9->dd_bt)*SectorSize;   /* cvt to byte pos */
PC.dd_bsz=IntegerOrder(OS9->dd_bsz);
memcpy(PC.dd_date,OS9->dd_date,5);
CvtStrNull(OS9->dd_name,PC.dd_name);
return PC;
}



