char *UsageDescription[]=
    {"",
     "Usage: OS9 drive command os9file pcfile",
     "",
     "  drive: is A: or B:",
     "         must be first argument unless you use -v option",
     "",
     "  command:",
     "      -dir: display an OS9 directory.  Optional OS9 path",
     "      -get: transfer an OS9 file to the PC.",
     "      -put: put a PC file onto OS9 disk.",
     "      -m  : make a virtual disk from an OS9 disk",
     "      -w  : write virtual disk to physical disk",
     "",
     "  Additional options:",
     "      -ascii:  copy the file as ascii",
     "      -extra:  Like OS9's DIR E command.  Shows extra info",
     "      -vxxxx:  Use emulator's 'virtual' disk.",
     "               xxxx is the path and filename to it",
     "      -z    :  debugging info.  Up to 3",
     0};



void Usage(void)
{char **cp=UsageDescription;

/*
printf("OS9 <-> PC file converter, %s\n",Version);
printf("(C)opyright by Carey Bloodworth, %s\n\n",Date);
*/

/* If the usage info gets any longer, put in a <pause, press enter> msg */
while (*cp) printf("%s\n",*cp++);
QuitProgram(EZERO);
}

void ParseArgs(int argc, char *argv[])
{char *cp;int fnames;int argnum;
argc--; /* remove the program's name from the list */
argnum=0;
fnames=0;

/*
  Loop through the args.
  Convert everything to lower case and all OS9's forward slash path
  seperators to MS-DOS's backward slash seperator
*/
while (argc-- && **argv++)
  {cp=*argv;
  while (*cp) 
    {*cp=tolower(*cp);
     if (*cp == '/') *cp='\\'; /* convert OS9's / to PC's \ */
     cp++;
    }

   if (options.debug) printf("argv: %s\n",*argv);

   argnum++;

   switch (*((short int *) *argv))
/*
  A neat trick.  It takes the first two chars and treats them as
  a 16 bit integer, which we can compare as two chars.
*/

     {
      case 'a:' : case 'b:' :
                  if (argnum != 1) goto pcpath;
                  options.drivenum=**argv-'a'; break;
                  /* drive num can only be first argument because  */
                  /* it could also be a PC path name               */

      case '\\a': case '-a' : case '/a' :
                 options.ascii=TRUE;
                 break;

      case '\\d': case '-d' : case '/d' :
                 options.dir=TRUE;
                 break;

      case '\\e': case '-e' : case '/e' :
                 options.fulldir=TRUE;
                 break;

      case '\\g': case '-g' : case '/g' :
                 options.get=TRUE;
                 break;

      case '\\m': case '-m' : case '/m' :
                 options.makevirt=TRUE;
                 break;

      case '\\p': case '-p' : case '/p' :
                 options.put=TRUE;
                 break;

      case '\\v': case '-v' : case '/v' :
                 options.virtdisk=TRUE;
                 strncpy(options.vdiskname,(*argv)+2,PATHLEN-1);
                 break;

      case '\\w': case '-w' : case '/w' :
                 options.writevirt=TRUE;
                 break;

      case '\\z': case '-z' : case '/z' :
                 options.debug++;
                 break;

      default:   /* If it's no option, then assume it's a file/path name */
              if ((**argv == '-') || (**argv == '/') || (**argv == '\\') )
                 {fprintf(stderr,"Unknown option: %s\n",*argv);
                  Usage();
                  QuitProgram(0);
                 }
/*
printf("default arg is %04x\n",(*((short int *) *argv)) );
*/
pcpath:
              if (++fnames == 1) strncpy(options.pathname,*argv,PATHLEN-1);
              else if (fnames == 2) strncpy(options.pcfilename,*argv,PATHLEN-1);
              else {fprintf(stderr,"Too many filenames: %s\n",*argv);
                    Usage();
                    QuitProgram(0);
                   }
              break;
     }
  }

if (! options.dir) PeelLastPath(); /* peel last name off path */

if (options.writevirt)  /* kludge to make it read LSN0 from there */
  {options.virtdisk=TRUE; /* instead of the floppy drive */
   memcpy(options.vdiskname,options.filename,PATHLEN);
  }


if (options.debug)
  {printf("Path: %s\n",options.pathname);
   printf("File: %s\n",options.filename);
   printf("Virt: %s\n",options.vdiskname);
   printf("PCfl: %s\n",options.pcfilename);
  }

if (!(options.dir || options.get || options.put ||
      options.makevirt || options.writevirt)) Usage();
if ((options.drivenum==-1) && (options.virtdisk==FALSE)) Usage();
/*
if (options.put && !options.virtdisk)
   {fprintf(stderr,"You forgot!  During debugging, you can only");
    fprintf(stderr," write to virtual disks\n");
    QuitProgram(0);
   }
*/

/* Make sure get/put have two filenames */
if (options.put || options.get)
  if ((options.pcfilename[0] == 0) ||
      (options.filename[0] == 0) )
     {printf("Option requires both filenames\n");
      Usage();
     }

if (options.makevirt || options.writevirt)
   if (options.filename[0] == 0)
      {printf("Reading/Writing virtual disks require the filename\n");
       Usage();
      }

if (options.virtdisk && (options.vdiskname[0]==0))
   {printf("Virtual disk usage requires a filename immediatly after -v\n");
    Usage();
   }

}

void PeelLastPath(void)
{char *cp, *path;

path=cp=options.pathname;

while (*path)
  {if ((*path == '\\') || (*path == '/')) cp=path+1; /* point to after / */
   path++;
  }

strncpy(options.filename,cp,PATHLEN);
if (cp != options.pathname) cp--;
*cp=0;  /* cleave filename off pathname */
}

