/*
** $Id:$
**
** File: ops48.h -- external declarations of opcodes for MCS48 emulator
**
*/

#ifndef _H_OPS48_
#define _H_OPS48_

void _M48ADDID(MCS48 *cpu, byte op);
void _M48ADDREG(MCS48 *cpu, byte op);
void _M48ADDM(MCS48 *cpu, byte op);
void _M48ADDC(MCS48 *cpu, byte op);
void _M48ADDRGC(MCS48 *cpu, byte op);
void _M48ADDMC(MCS48 *cpu, byte op);
void _M48ANDID(MCS48 *cpu, byte op);
void _M48ANDREG(MCS48 *cpu, byte op);
void _M48ANDMM(MCS48 *cpu, byte op);
void _M48ANDBUS(MCS48 *cpu, byte op);
void _M48ANDP4(MCS48 *cpu, byte op);
void _M48CALL(MCS48 *cpu, byte op);
void _M48CLRA(MCS48 *cpu, byte op);
void _M48CLRC(MCS48 *cpu, byte op);
void _M48CLRF1(MCS48 *cpu, byte op);
void _M48CLRF0(MCS48 *cpu, byte op);
void _M48CPLA(MCS48 *cpu, byte op);
void _M48CPLC(MCS48 *cpu, byte op);
void _M48CPLF0(MCS48 *cpu, byte op);
void _M48CPLF1(MCS48 *cpu, byte op);
void _M48DAA(MCS48 *cpu, byte op);
void _M48DECA(MCS48 *cpu, byte op);
void _M48DECR(MCS48 *cpu, byte op);
void _M48DISI(MCS48 *cpu, byte op);
void _M48DISTI(MCS48 *cpu, byte op);
void _M48DJNZ(MCS48 *cpu, byte op);
void _M48ENI(MCS48 *cpu, byte op);
void _M48ENTI(MCS48 *cpu, byte op);
void _M48ENT0(MCS48 *cpu, byte op);
void _M48INP(MCS48 *cpu, byte op);
void _M48INCA(MCS48 *cpu, byte op);
void _M48INCR(MCS48 *cpu, byte op);
void _M48INCM(MCS48 *cpu, byte op);
void _M48INSA(MCS48 *cpu, byte op);
void _M48JMPIF(MCS48 *cpu, byte op);
void _M48JBB(MCS48 *cpu, byte op);
void _M48JMP(MCS48 *cpu, byte op);
void _M48JMPP(MCS48 *cpu, byte op);
void _M48MOVAID(MCS48 *cpu, byte op);
void _M48MOVAR(MCS48 *cpu, byte op);
void _M48MOVAM(MCS48 *cpu, byte op);
void _M48MOVAPSW(MCS48 *cpu, byte op);
void _M48MOVRID(MCS48 *cpu, byte op);
void _M48MOVRA(MCS48 *cpu, byte op);
void _M48MOVMA(MCS48 *cpu, byte op);
void _M48MOVMID(MCS48 *cpu, byte op);
void _M48MOVPSWA(MCS48 *cpu, byte op);
void _M48MOVDAP(MCS48 *cpu, byte op);
void _M48MOVDPA(MCS48 *cpu, byte op);
void _M48MOVAT(MCS48 *cpu, byte op);
void _M48MOVTA(MCS48 *cpu, byte op);
void _M48MOVP3(MCS48 *cpu, byte op);
void _M48MOVPAA(MCS48 *cpu, byte op);
void _M48MOVXAM(MCS48 *cpu, byte op);
void _M48MOVXMA(MCS48 *cpu, byte op);
void _M48ORLAR(MCS48 *cpu, byte op);
void _M48ORLAM(MCS48 *cpu, byte op);
void _M48ORLAID(MCS48 *cpu, byte op);
void _M48ORLP(MCS48 *cpu, byte op);
void _M48ORLD(MCS48 *cpu, byte op);
void _M48OUTLBUS(MCS48 *cpu, byte op);
void _M48OUTLP(MCS48 *cpu, byte op);
void _M48RET(MCS48 *cpu, byte op);
void _M48RETR(MCS48 *cpu, byte op);
void _M48RLA(MCS48 *cpu, byte op);
void _M48RLCA(MCS48 *cpu, byte op);
void _M48RRA(MCS48 *cpu, byte op);
void _M48RRCA(MCS48 *cpu, byte op);
void _M48SELM0(MCS48 *cpu, byte op);
void _M48SELM1(MCS48 *cpu, byte op);
void _M48SELR0(MCS48 *cpu, byte op);
void _M48SELR1(MCS48 *cpu, byte op);
void _M48STPTC(MCS48 *cpu, byte op);
void _M48STRTTC(MCS48 *cpu, byte op);
void _M48STRTT(MCS48 *cpu, byte op);
void _M48SWAPA(MCS48 *cpu, byte op);
void _M48XCHAID(MCS48 *cpu, byte op);
void _M48XCHAM(MCS48 *cpu, byte op);
void _M48XCHADA(MCS48 *cpu, byte op);
void _M48XRLAID(MCS48 *cpu, byte op);
void _M48XRLR(MCS48 *cpu, byte op);
void _M48XRLM(MCS48 *cpu, byte op);
void _M48NOP(MCS48 *cpu, byte op);
void _M48INVAL(MCS48 *cpu, byte op);

void _M48ICALL(MCS48 *cpu, int addr);

#endif /* _H_OPS48_ */

/*
** Change Log
** ----------
** $Log:$
*/
