#include <stdio.h>
#include <fcntl.h>

char fn[255], fn2[255];
unsigned char buf[1024];
signed char buf2[1024];

static unsigned char dsp_ulaw[256] = {
    31,   31,   31,   32,   32,   32,   32,   33, 
    33,   33,   33,   34,   34,   34,   34,   35, 
    35,   35,   35,   36,   36,   36,   36,   37, 
    37,   37,   37,   38,   38,   38,   38,   39, 
    39,   39,   39,   40,   40,   40,   40,   41, 
    41,   41,   41,   42,   42,   42,   42,   43, 
    43,   43,   43,   44,   44,   44,   44,   45, 
    45,   45,   45,   46,   46,   46,   46,   47, 
    47,   47,   47,   48,   48,   49,   49,   50, 
    50,   51,   51,   52,   52,   53,   53,   54, 
    54,   55,   55,   56,   56,   57,   57,   58, 
    58,   59,   59,   60,   60,   61,   61,   62, 
    62,   63,   63,   64,   65,   66,   67,   68, 
    69,   70,   71,   72,   73,   74,   75,   76, 
    77,   78,   79,   81,   83,   85,   87,   89, 
    91,   93,   95,   99,  103,  107,  111,  119, 
   255,  247,  239,  235,  231,  227,  223,  221, 
   219,  217,  215,  213,  211,  209,  207,  206, 
   205,  204,  203,  202,  201,  200,  199,  198, 
   197,  196,  195,  194,  193,  192,  191,  191, 
   190,  190,  189,  189,  188,  188,  187,  187, 
   186,  186,  185,  185,  184,  184,  183,  183, 
   182,  182,  181,  181,  180,  180,  179,  179, 
   178,  178,  177,  177,  176,  176,  175,  175, 
   175,  175,  174,  174,  174,  174,  173,  173, 
   173,  173,  172,  172,  172,  172,  171,  171, 
   171,  171,  170,  170,  170,  170,  169,  169, 
   169,  169,  168,  168,  168,  168,  167,  167, 
   167,  167,  166,  166,  166,  166,  165,  165, 
   165,  165,  164,  164,  164,  164,  163,  163, 
   163,  163,  162,  162,  162,  162,  161,  161, 
   161,  161,  160,  160,  160,  160,  159,  159, 
};
                                                                         
#define AUDIO_CONV(A) (dsp_ulaw[0xFF&(128+(A - 0x40))])


int main(int argc, char **argv)
{
    int min = 257, max = -1;
    int cnt;
    int ofd;

    for (cnt = 1 ; cnt < 8; cnt++ ) {
	int fd;
	int n;
	int fmin = 0, fmax = 0;

	sprintf(fn2,"audio%02d.8",cnt);
	ofd = open(fn2,O_WRONLY|O_BINARY|O_CREAT|O_TRUNC,0666);
	if (ofd < 0) {
	    perror(fn2);
	    exit(1);
	}

	sprintf(fn,"audio%02d.out",cnt);
	fd = open(fn,O_RDONLY|O_BINARY);
	if (fd < 0) {
	    perror(fn);
	    exit(1);
	}

	printf("%s -> %s .. ",fn,fn2); fflush(stdout);
	while (1) {
	    int i;
	    int samp;
	    n = read(fd,buf,sizeof(buf));
	    if (n == -1) {
		perror("read");
		exit(1);
	    }
	    for ( i = 0 ; i < n ; i++ ) {
		samp = buf[i];
		/* samp -= 0x40; */
		buf2[i] = AUDIO_CONV(samp);
		if (samp > fmax) fmax = samp;
		else if (samp != 0 && samp < fmin) fmin = samp;
	    }
	    if (write(ofd,buf2,n * sizeof(buf2[0])) != n * sizeof(buf2[0])) {
		perror("write");
		exit(1);
	    }
	    if (n < sizeof(buf)) break;
	}
	printf("done. (min = %d, max = %d)\n", fmin,fmax);
	if (fmax > max) max = fmax;
	if (fmin < min) min = fmin;
	close(fd);
	close(ofd);
    }
    printf("min= %d (0x%x) , max = %d (0x%x)\n",min,min,max,max);
    return (0);
}

