#include <stdio.h>
#include <fcntl.h>

char fn[255], fn2[255];
unsigned char buf[1024];
signed char buf2[1024];

int main(int argc, char **argv)
{
    int min = 257, max = -1;
    int cnt;

    for (cnt = 1 ; cnt < 7; cnt++ ) {
	int fd, ofd;
	int n;
	int fmin = 0, fmax = 0;

	sprintf(fn2,"audio%02d.8",cnt);
	ofd = open(fn2,O_WRONLY|O_BINARY|O_CREAT|O_TRUNC,0666);
	if (ofd < 0) {
	    perror(fn2);
	    exit(1);
	}

	sprintf(fn,"audio%02d.out",cnt);
	fd = open(fn,O_RDONLY|O_BINARY);
	if (fd < 0) {
	    perror(fn);
	    exit(1);
	}

	printf("%s -> %s .. ",fn,fn2); fflush(stdout);
	while (1) {
	    int i;
	    int samp;
	    n = read(fd,buf,sizeof(buf));
	    if (n == -1) {
		perror("read");
		exit(1);
	    }
	    for ( i = 0 ; i < n ; i++ ) {
		samp = buf[i] >> 2;
		/* samp -= 0x40; */
		buf2[i] = samp;
		if (samp > fmax) fmax = samp;
		else if (samp != 0 && samp < fmin) fmin = samp;
	    }
	    if (write(ofd,buf2,n * sizeof(buf2[0])) != n * sizeof(buf2[0])) {
		perror("write");
		exit(1);
	    }
	    if (n < sizeof(buf)) break;
	}
	printf("done. (min = %d, max = %d)\n", fmin,fmax);
	if (fmax > max) max = fmax;
	if (fmin < min) min = fmin;
	close(fd);
	close(ofd);
    }
    printf("min= %d (0x%x) , max = %d (0x%x)\n",min,min,max,max);
    return (0);
}
