;
; All documented 65C02 and 6502 instructions with proper AS6502 syntax
;
; The instructions that run only on 65C02 are marked with `*'.
;
 
.radix x

adc #12 	; 69 12
adc +12		; 65 12
adc +$12	; 65 12
adc +#12	; 65 0c
adc %10		; 65 02
adc &123	; 65 53
adc #$10	; 69 10
adc #%10	; 69 02
adc #&10	; 69 08
adc ##10	; 69 0a
adc 1234	; 6D 34 12
adc 12		; 65 12
adc 12,x	; 75 12
adc 1234,x	; 7D 34 12
adc 1234,y	; 79 34 12
adc ((12),x)	; 61 12
adc (12),y	; 71 12
adc (12*3),y	; 71 36
adc +(12*3),y	; 79 36 00
adc +(12*3),x	; 75 36
adc (12)	; 72 12 	*

and #12 	; 29 12
and 1234	; 2D 34 12
and 12		; 25 12
and 12,x	; 35 12
and 1234,x	; 3D 34 12
and 1234,y	; 39 34 12
and (12,x)	; 21 12
and (12),y	; 31 12
and (12)	; 32 12 	*

asl a		; 0A
asl		; 0A
asl 1234	; 0E 34 12
asl 12		; 06 12
asl 12,x	; 16 12
asl 1234,x	; 1E 34 12

bbr0 12,*	; 0F 12 FD	*
bbr1 12,*	; 1F 12 FD	*
bbr2 12,*	; 2F 12 FD	*
bbr3 12,*	; 3F 12 FD	*
bbr4 12,*	; 4F 12 FD	*
bbr5 12,*	; 5F 12 FD	*
bbr6 12,*	; 6F 12 FD	*
bbr7 12,*	; 7F 12 FD	*

bbs0 12,*	; 8F 12 FD	*
bbs1 12,*	; 9F 12 FD	*
bbs2 12,*	; AF 12 FD	*
bbs3 12,*	; BF 12 FD	*
bbs4 12,*	; CF 12 FD	*
bbs5 12,*	; DF 12 FD	*
bbs6 12,*	; EF 12 FD	*
bbs7 12,*	; FF 12 FD	*

bcc *		; 90 FE

bcs *		; B0 FE

beq *		; F0 FE

bit #12 	; 89 12 	*
bit 1234	; 2C 34 12
bit 12		; 24 12
bit 12,x	; 34 12 	*
bit 1234,x	; 3C 34 12	*

bmi *		; 30 FE

bne *		; D0 FE

bpl *		; 10 FE

bra *		; 80 FE 	*

brk		; 00

bvc *		; 50 FE

bvs *		; 70 FE

clc		; 18

cld		; D8

cli		; 58

clv		; B8

cmp #12 	; C9 12
cmp 1234	; CD 34 12
cmp 12		; C5 12
cmp 12,x	; D5 12
cmp 1234,x	; DD 34 12
cmp 12,y	; D9 12 00
cmp 1234,y	; D9 34 12
cmp (12,x)	; C1 12
cmp (12),y	; D1 12
cmp (12)	; D2 12 	*

cpx #12 	; E0 12
cpx 1234	; EC 34 12
cpx 12		; E4 12

cpy #12 	; C0 12
cpy 1234	; CC 34 12
cpy 12		; C4 12

dec a		; 3A		*
dec		; 3A		*
dec 1234	; CE 34 12
dec 12		; C6 12
dec 12,x	; D6 12
dec 1234,x	; DE 34 12

dex		; CA

dey		; 88

eor #12 	; 49 12
eor 1234	; 4D 34 12
eor 12		; 45 12
eor 12,x	; 55 12
eor 1234,x	; 5D 34 12
eor 1234,y	; 59 34 12
eor (12,x)	; 41 12
eor (12),y	; 51 12
eor (12)	; 52 12 	*

inc a		; 1A		*
inc		; 1A		*
inc 1234	; EE 34 12
inc 12		; E6 12
inc 12,x	; F6 12
inc 1234,x	; FE 34 12

inx		; E8

iny		; C8

jmp 12
jmp (12)
jmp (12,x)
jmp 1234	; 4C 34 12
jmp (1234)      ; 6C 34 12
jmp (1234,x)	; 7C 34 12	*

jsr 1234	; 20 34 12

lda #12 	; A9 12
lda 1234	; AD 34 12
lda 12		; A5 12
lda 12,x	; B5 12
lda 1234,x	; BD 34 12
lda 1234,y	; B9 34 12
lda (12,x)	; A1 12
lda (12),y	; B1 12
lda (12)	; B2 12 	*

ldx #12 	; A2 12
ldx 1234	; AE 34 12
ldx 12		; A6 12
ldx 12,y	; B6 12
ldx 1234,y	; BE 34 12

ldy #12 	; A0 12
ldy 1234	; AC 34 12
ldy 12		; A4 12
ldy 12,x	; B4 12
ldy 1234,x	; BC 34 12

lsr a		; 4A
lsr		; 4A
lsr 1234	; 4E 34 12
lsr 12		; 46 12
lsr 12,x	; 56 12
lsr 1234,x	; 5E 34 12

nop		; EA

ora #12 	; 09 12
ora 1234	; 0D 34 12
ora 12		; 05 12
ora 12,x	; 15 12
ora 1234,x	; 1D 34 12
ora 1234,y	; 19 34 12
ora (12,x)	; 01 12
ora (12),y	; 11 12
ora (12)	; 12 12 	*

pha		; 48

php		; 08

phx		; DA		*

phy		; 5A		*

pla		; 68

plp		; 28

plx		; FA		*

ply		; 7A		*

rmb0 12 	; 07 12 	*
rmb1 12 	; 17 12 	*
rmb2 12 	; 27 12 	*
rmb3 12 	; 37 12 	*
rmb4 12 	; 47 12 	*
rmb5 12 	; 57 12 	*
rmb6 12 	; 67 12 	*
rmb7 12 	; 77 12 	*

rol a		; 2A
rol		; 2A
rol 1234	; 2E 34 12
rol 12		; 26 12
rol 12,x	; 36 12
rol 1234,x	; 3E 34 12

ror a		; 6A
ror		; 6A
ror 1234	; 6E 34 12
ror 12		; 66 12
ror 12,x	; 76 12
ror 1234,x	; 7E 34 12

rti		; 40

rts		; 60

sbc #12 	; E9 12
sbc 1234	; ED 34 12
sbc 12		; E5 12
sbc 12,x	; F5 12
sbc 1234,x	; FD 34 12
sbc 1234,y	; F9 34 12
sbc (12,x)	; E1 12
sbc (12),y	; F1 12
sbc (12)	; F2 12 	*

sec		; 38

sed		; F8

sei		; 78

smb0 12 	; 87 12 	*
smb1 12 	; 97 12 	*
smb2 12 	; A7 12 	*
smb3 12 	; B7 12 	*
smb4 12 	; C7 12 	*
smb5 12 	; D7 12 	*
smb6 12 	; E7 12 	*
smb7 12 	; F7 12 	*

sta 1234	; 8D 34 12
sta 12		; 85 12
sta 12,x	; 95 12
sta 1234,x	; 9D 34 12
sta 1234,y	; 99 34 12
sta (12,x)	; 81 12
sta (12),y	; 91 12
sta (12)	; 92 12 	*

stx 1234	; 8E 34 12
stx 12		; 86 12
stx 12,y	; 96 12

sty 1234	; 8C 34 12
sty 12		; 84 12
sty 12,x	; 94 12

stz 1234	; 9C 34 12	*
stz 12		; 64 12 	*
stz 12,x	; 74 12 	*
stz 1234,x	; 9E 34 12	*

tax		; AA

tay		; A8

trb 1234	; 1C 34 12	*
trb 12		; 14 12 	*

tsb 1234	; 0C 34 12	*
tsb 12		; 04 12 	*

tsx		; BA

txa		; 8A

txs		; 9A

tya		; 98
