/* r6502.h */

/*
 * Modified from the code of Alan R. Baldwin by Marko Mkel
 * in the 28th of February 1993
 *
 * Author of the original file for 6800:
 *
 * Alan R. Baldwin
 * 721 Berkeley St.
 * Kent, Ohio  44240
 * United States of America
 *
 * The one who modified it for 65C02:
 *
 * Marko Mkel
 * Sillitie 10 A
 * 01480 Vantaa
 * Finland
 * Internet: Marko.Makela@Helsinki.Fi
 * EARN/BitNet: msmakela@finuh
 */

/*)BUILD
	$(PROGRAM) =	AS6502
	$(INCLUDE) = {
		ASM.H
		R6502.H
	}
	$(FILES) = {
		R52EXT.C
		R52MCH.C
		R52ADR.C
		R52PST.C
		ASMAIN.C
		ASLEX.C
		ASSYM.C
		ASSUBR.C
		ASEXPR.C
		ASDATA.C
		ASLIST.C
		ASOUT.C
	}
	$(STACK) = 2000
*/

struct adsym
{
	char	a_str[2];	/* addressing string */
	int	a_val;		/* addressing mode value */
};

#define	S_A	1
#define	S_X	2
#define	S_Y	3

/*
 * Addressing types
 */
#define S_ACCUM 30
#define S_IMM	31
#define S_ABS	32
#define S_ZP	33
#define S_ZPX	34
#define S_ZPY	35
#define S_ABSX	36
#define S_ABSY	37
#define S_IABS	38
#define S_IABSX 39
#define S_IMP	40
#define S_IZPX	43
#define S_IZPY	44
#define S_IZP	45

/*
 * Instruction types
 */
#define S_ACCU1 60
#define S_ACCU2 61
#define S_BB	62
#define S_BRA	63
#define S_BIT	64
#define S_IMPLY 65
#define S_CP	66
#define S_LDSTX 67
#define S_LDSTY 68
#define S_JMP	69
#define S_JSR	70
#define S_MB	71
#define S_STZ	72

/*
S_ACCU1
imm|abs|zp|izpx|izpy|zpx|absx|absy|izp
	ADC,AND,CMP,EOR,LDA,ORA,SBC
	STA (!imm)

imm=izpx+8,abs=izpx+C,zp=izpx+4,izpx,izpy=izpx+10,
zpx=izpx+14,absx=izpx+1C,absy=izpx+18,*ind=izpx+11

S_ACCU2
abs|zp|accum|zpx|absx
	ASL,LSR,ROL,ROR
	DEC,INC (!accum*)

abs=zp+8,accum=zp+4,zpx=zp+10,absx=zp+18
accum*=zp^FC

S_BB
zprel
	BBRn,BBSn

S_BRA
rel
	BCC,BCS,BEQ,BMI,BNE,BPL,BRA,BVC,BVS

S_BIT
imm*|abs|zp|zpx*|absx*
	BIT
imm*=zp^AD,abs=zp+8,zp,zpx*=zp+10,absx*=zp+18

S_STZ
abs|zp|zpx|absx
	STZ
abs=zp+38,zp,zpx=zp+10,absx=zp+3A

S_IMPLY
imp
	BRK,CLC,CLD,CLI,CLV,DEX,DEY,INX,INY,NOP,PHA,PHP,PHX,PHY,PLA,
	PLP,PLX,PLY,RTI,RTS,SEC,SED,SEI,TAX,TAY,TSX,TXA,TXS,TYA

S_CP
imm|abs|zp
	CPX,CPY
	TRB,TSB (!imm)

imm,abs=imm+C,zp=imm+4

S_LDSTX
imm|abs|zp|absy|zpy
	LDX
	STX (!imm,!absy)
imm,abs=imm+C,zp=imm+4,absy=imm+1C,zpy=imm+14

S_LDSTY
imm|abs|zp|absx|zpx
	LDY
	STY (!imm,!absx)
imm,abs=imm+C,zp=imm+4,absx=imm+1C,zpx=imm+14

S_JMP
abs|iabs|iabsx
	JMP
abs,iabs=abs+20,iabsx=abs+30

S_JSR
abs
	JSR
abs

S_MB
zp
	RMBn,SMBn
*/

	/* machine dependent functions */

	/* r52adr.c */
extern	struct	adsym	a[],xy[];
extern	int		addr();
extern	int		admode();
extern	int		any();
extern	int		srch();

	/* r52mch.c */
extern	VOID		machin();
extern	VOID		minit();
extern	VOID		comma();
