/* r52mch.c */

/*
 * Modified from the code of Alan R. Baldwin by Marko Mkel
 * in the 28th of February 1993 and in the 1st, 8th and 9th of March 1993
 *
 * Author of the original file for 6800:
 *
 * Alan R. Baldwin
 * 721 Berkeley St.
 * Kent, Ohio  44240
 * United States of America
 *
 * The one who modified it for 65C02:
 *
 * Marko Mkel
 * Sillitie 10 A
 * 01480 Vantaa
 * Finland
 * Internet: Marko.Makela@Helsinki.Fi
 * EARN/BitNet: msmakela@finuh
 */

#include <stdio.h>
#include <setjmp.h>
#include "asm.h"
#include "r6502.h"

/*
 * Process a machine op.
 */
VOID
machine(mp)
struct mne *mp;
{
	register op, t1;
	struct expr e1;
	int v1;

	op = mp->m_valu;
	switch (mp->m_type) {

	case S_IMPLY:
		outab(op);
		break;

	case S_BRA:
		expr(&e1, 0);
		outab(op);
		if (e1.e_base.e_ap == NULL || e1.e_base.e_ap == dot.s_area) {
			v1 = e1.e_addr - dot.s_addr - 1;
			if ((v1 < -128) || (v1 > 127))
				aerr();
			outab(v1);
		} else {
			outrb(&e1, R_PCR);
		}
		if (e1.e_mode != S_USER)
			rerr();
		break;

	case S_BB:	/* 65c02 */
		expr(&e1, 0);
		outab(op);
		if (e1.e_addr & ~0xFF)
			aerr();
		outrb(&e1, R_PAG0);
		comma();
		dot.s_addr -= 2;/* Cancel the effect of outab and outrb */
		expr(&e1, 0);	/* to prevent errors with DOT addressing */
		dot.s_addr += 2;
		if (e1.e_base.e_ap == NULL || e1.e_base.e_ap == dot.s_area) {
			v1 = e1.e_addr - dot.s_addr - 1;
			if ((v1 < -128) || (v1 > 127))
				aerr();
			outab(v1);
		} else {
			outrb(&e1, R_PCR);
		}
		if (e1.e_mode != S_USER)
			rerr();
		break;

	case S_MB:	/* 65c02 */
		if (addr(&e1) != S_ZP)
			qerr();
		outab(op);
		outrb(&e1, R_PAG0);
		break;

	case S_STZ: /* 65c02 */
		switch (addr(&e1)) {
			case S_ABS:
				outab(op+0x38);
				outrw(&e1, R_USGN);
				break;
			case S_ZP:
				outab(op);
				outrb(&e1, R_PAG0);
				break;
			case S_ZPX:
				outab(op+0x10);
				outrb(&e1, R_PAG0);
				break;
			case S_ABSX:
				outab(op+0x3A);
				outrw(&e1, R_USGN);
				break;
			default:
				qerr();
        }
		break;

	case S_JSR:
		t1 = addr(&e1);
		if (t1 != S_ABS && t1 != S_ZP)
			qerr();
		outab(op);
		outrw(&e1, R_USGN);
		break;

	case S_JMP:
		switch (addr(&e1)) {
			case S_ZP:
			case S_ABS:
                outab(op);
				break;
			case S_IZP:
			case S_IABS:
				outab(op+0x20);
				break;
			case S_IZPX:
			case S_IABSX:
				outab(op+0x30); /* 65c02 */
				break;
			default:
				outab(op);
				qerr();
		}
		outrw(&e1, R_USGN);
		break;

	case S_ACCU1:
		switch (addr(&e1)) {
			case S_IMM:
				outab(op+8);
				outrb(&e1, R_USGN);
				if (op == 0x81)
					qerr();
				break;
			case S_ABS:
				outab(op+0x0C);
				outrw(&e1, R_USGN);
				break;
			case S_ZP:
				outab(op+4);
				outrb(&e1, R_PAG0);
				break;
			case S_IZPX:
				outab(op);
				outrb(&e1, R_PAG0);
				break;
			case S_IZPY:
				outab(op+0x10);
				outrb(&e1, R_PAG0);
				break;
			case S_ZPX:
				outab(op+0x14);
				outrb(&e1, R_PAG0);
				break;
			case S_ABSX:
				outab(op+0x1C);
				outrw(&e1, R_USGN);
				break;
			case S_ZPY:
			case S_ABSY:
				outab(op+0x18);
				outrw(&e1, R_USGN);
				break;
			case S_IZP:
				outab(op+0x11); /* 65c02 */
				outrb(&e1, R_PAG0);
				break;
			default:
				qerr();
		}
		break;

	case S_ACCU2:
		switch (addr(&e1)) {
			case S_ABS:
				outab(op+8);
				outrw(&e1, R_USGN);
				break;
			case S_ACCUM:
			case S_IMP:
				if (op & 0x80)
					outab(op^0xFC); /* 65c02 */
				else
					outab(op+4);
				break;
			case S_ZP:
				outab(op);
				outrb(&e1, R_PAG0);
				break;
			case S_ZPX:
				outab(op+0x10);
				outrb(&e1, R_PAG0);
				break;
			case S_ABSX:
				outab(op+0x18);
				outrw(&e1, R_USGN);
				break;
			default:
				qerr();
		}
		break;

	case S_BIT:
		switch (addr(&e1)) {
			case S_ABS:
				outab(op+8);
				outrw(&e1, R_USGN);
				break;
			case S_ZP:
				outab(op);
				outrb(&e1, R_PAG0);
				break;
			case S_IMM:
				outab(op^0xAD); /* 65c02 */
				outrb(&e1, R_USGN);
				break;
			case S_ZPX:
				outab(op+0x10); /* 65c02 */
				outrb(&e1, R_PAG0);
				break;
			case S_ABSX:
				outab(op+0x18); /* 65c02 */
				outrw(&e1, R_USGN);
				break;
			default:
				qerr();
		}
		break;

	case S_CP:
		switch (addr(&e1)) {
			case S_IMM:
				if(!(op & 0x80))	/* 65c02 */
					qerr();
				outab(op);
				outrb(&e1, R_USGN);
				break;
			case S_ZP:
				outab(op+4);
				outrb(&e1, R_USGN);
				break;
			case S_ABS:
				outab(op+0x0C);
				outrw(&e1, R_USGN);
				break;
			default:
				qerr();
		}
		break;

	case S_LDSTX:
	case S_LDSTY:
		switch (addr(&e1)) {
			case S_IMM:
				if (!(op & 0x20))
					qerr();
				outab(op);
				outrb(&e1, R_USGN);
				break;
			case S_ABS:
				outab(op+0x0C);
				outrw(&e1, R_USGN);
				break;
			case S_ZP:
				outab(op+4);
				outrb(&e1, R_PAG0);
				break;
			case S_ABSX:
				if (mp->m_type == S_LDSTX || !(op & 0x20)) {
					qerr();
					break;
				}
				outab(op+0x1C);
				outrw(&e1, R_USGN);
				break;
			case S_ABSY:
				if (mp->m_type == S_LDSTY || !(op & 0x20)) {
					qerr();
					break;
				}
				outab(op+0x1C);
				outrw(&e1, R_USGN);
				break;
			case S_ZPX:
				if (mp->m_type == S_LDSTX) {
					qerr();
					break;
				}
				outab(op+0x14);
				outrb(&e1, R_PAG0);
				break;
			case S_ZPY:
				if (mp->m_type == S_LDSTY) {
					qerr();
					break;
				}
				outab(op+0x14);
				outrb(&e1, R_PAG0);
				break;
			default:
				qerr();
		}
		break;

    default:
		err('o');
	}
}

/*
 * The next character must be a
 * comma.
 */
VOID
comma()
{
	if (getnb() != ',')
		qerr();
}

/*
 * Machine dependent initialization
 */
VOID
minit()
{
}
