/* r52adr.c */

/*
 * Modified from the code of Alan R. Baldwin by Marko Mkel
 * in the 28th of February 1993
 *
 * Author of the original file for 6800:
 *
 * Alan R. Baldwin
 * 721 Berkeley St.
 * Kent, Ohio  44240
 * United States of America
 *
 * The one who modified it for 65C02:
 *
 * Marko Mkel
 * Sillitie 10 A
 * 01480 Vantaa
 * Finland
 * Internet: Marko.Makela@Helsinki.Fi
 * EARN/BitNet: msmakela@finuh
 */

#include <stdio.h>
#include <setjmp.h>
#include "asm.h"
#include "r6502.h"

int
addr(esp)
register struct expr *esp;
{
  register c;

  if ((c = getnb()) == '#') {
    expr(esp, 0);
    esp->e_mode = S_IMM;
    if (esp->e_addr & ~0xFF)
      aerr();
  }
  else if (c == '(') {
    expr(esp, 0);
    if ((c = getnb()) == ')') {
      if (more()) {
	comma();
	if (admode(xy) != S_Y || more())
	  qerr();
	esp->e_mode = S_IZPY;
	if (esp->e_addr & ~0xFF)
	  err('d');
      }
      else
	esp->e_mode = (esp->e_addr & ~0xFF) ? S_IABS : S_IZP;
    }
    else {
      unget(c);
      comma();
      if (admode(xy) != S_X)
	qerr();
      esp->e_mode = (esp->e_addr & ~0xFF) ? S_IABSX : S_IZPX;
      if (getnb() != ')' || more())
	qerr();
    }
  }
  else {
    unget(c);

    if (admode(a)) {
      if (more())
	qerr();
      esp->e_mode = S_ACCUM;
    }
    else if (!more()) {
      esp->e_mode = S_IMP;
    }
    else {
      expr(esp,0);

      if (!more())
	esp->e_mode = (esp->e_addr & ~0xFF) ? S_ABS : S_ZP;
      else {
	comma();

	switch (admode(xy)) {
	case S_X:
	  esp->e_mode = (esp->e_addr & ~0xFF) ? S_ABSX : S_ZPX;
	  break;
	case S_Y:
	  esp->e_mode = (esp->e_addr & ~0xFF) ? S_ABSY : S_ZPY;
	  break;
	default:
	  qerr();
	}
      }
    }
  }
  return (esp->e_mode);
}

/*
 * Enter admode() to search a specific addressing mode table
 * for a match. Return the addressing value on a match or
 * zero for no match.
 */
int
admode(sp)
register struct adsym *sp;
{
  register char *ptr;
  register int i;
  unget(getnb());
  i = 0;
  while ( *(ptr = (char *) &sp[i]) ) {
    if (srch(ptr)) {
      return(sp[i].a_val);
    }
    i++;
  }
  return(0);
}

/*
 *      srch --- does string match ?
 */
int
srch(str)
register char *str;
{
  register char *ptr;
  ptr = ip;

#if CASE_SENSITIVE
  while (*ptr && *str) {
    if(*ptr != *str)
      break;
    ptr++;
    str++;
  }
  if (*ptr == *str) {
    ip = ptr;
    return(1);
  }
#else
  while (*ptr && *str) {
    if(ccase[*ptr] != ccase[*str])
      break;
    ptr++;
    str++;
  }
  if (ccase[*ptr] == ccase[*str]) {
    ip = ptr;
    return(1);
  }
#endif

  if (!*str)
    if (any(*ptr," \t\n,);")) {
      ip = ptr;
      return(1);
    }
  return(0);
}

/*
 *      any --- does str contain c?
 */
int
any(c,str)
char    c, *str;
{
  while (*str)
    if(*str++ == c)
      return(1);

  return(0);
}

struct adsym	a[] = { 	/* accumulator */
  "a", S_A,
  "", 0
};

struct adsym	xy[] = {	/* index registers */
  "x", S_X,
  "y", S_Y,
  "", 0
};
