package org.jenison.app.patcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

import org.jenison.datatype.BitmapBuffer;
import org.jenison.datatype.ByteConverter;

/**
 * @author mark
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class JPatcher {

	public static void main(String[] args) throws IOException {
		if (validInputs(args))
		{
			applyPatch(args);
		}
		else
		{
			System.out.println("Usage: patcher <file> <patchfile>");
			System.out.println("Patch file format:");
			System.out.println("Offset $XXXX: From $YY To $ZZ");
			System.out.println("XXXX = offset");
			System.out.println("YY = original byte value in hex");
			System.out.println("ZZ = new byte value in hex");
			System.out.println("Semi-colon at beginning of line is a comment.");
			System.out.println("Example:");
			System.out.println("; My patch file");
			System.out.println("Offset $141B: From $1C To $08");
		}
	}
	
	public static boolean validInputs(String[] inputs)
	{
		if (inputs != null && inputs.length == 2)
		{
			// so far so good
			File f = new File(inputs[0]);
			
			if (f.exists() && f.canRead())
			{
				if (!f.canWrite())
				{
					System.out.println("Unable to patch file: cannot write to file");		
					return false;
				}
			}
			else
			{
				System.out.println("Unable to read file to patch");
				return false;
			}
			File f2 = new File(inputs[1]);
			
			if (f2.exists() && f.canRead())
			{
				// all set
			}
			else
			{
				System.out.println("Unable to read patch file");
			}
		}
		else
		{
			return false;
		}
		return true;
	}
	
	public static void applyPatch(String files[]) throws IOException
	{
		int errorCode = 0;
		// files already validated
		File romsource = new File(files[0]);
		File patchfilesource = new File(files[1]);
		FileReader 	patchfile = new FileReader(patchfilesource);	
		
		// ok, here we go
		BitmapBuffer bmb = BitmapBuffer.loadFile(romsource);	
		BufferedReader br = new BufferedReader(patchfile);
		String line;
		String tmp;
		int offset;
		int colonIndex;
		int index;
		byte origByte;
		byte toByte;
		byte wasByte;
		int fromIndex;
		int toIndex;
		int lineCount = 0;
		char[] buff = new char[1];
		boolean patched = false;
		while ((line = br.readLine()) != null)
		{
			lineCount++;
			if (!line.startsWith(";"))
			{
				if (line.startsWith("Offset $"))
				{
					// find colon
					if ((colonIndex = line.indexOf(":")) != -1)
					{	
						String offsetStr = line.substring(8,colonIndex);
						offset = Integer.parseInt(offsetStr,16);
						// find "From"
						tmp = line.substring(colonIndex);
						fromIndex = tmp.indexOf("From $");
						if (fromIndex == -1)
						{
							System.out.println("No 'From' line: "+line);
						}
						else
						{
							toIndex = tmp.indexOf("To $");
							if (toIndex == -1)
							{
								System.out.println("No 'To' line: "+line);
							}
							else
							{						
								String wasStr = tmp.substring(fromIndex+6,toIndex);
								wasByte = (byte)Integer.parseInt(wasStr.trim(),16);
								String toStr = tmp.substring(toIndex+4);
								toByte = (byte)Integer.parseInt(toStr.trim(),16);
								// check if orig byte matches
								if (bmb.getSize() > offset)
								{
									origByte = bmb.getByte(offset);
									bmb.setByte(offset,toByte);
									if (wasByte != toByte)
									{
										patched = true;
									}
									if (wasByte != origByte)
									{
										System.out.println("Offset $"+Integer.toHexString(offset)+
										" was $"+
										ByteConverter.toHex(origByte) +
										", should have been $"+ByteConverter.toHex(wasByte));
										errorCode = 1;		
									}							
								}		
								else
								{
									System.out.println("Offset $"+Integer.toHexString(offset)+" EOF");						
									errorCode = 2;
								} //end if within range
							} // end to check
						} // end from check
					}
					else
					{
						System.out.println("Missing ':' after offset: "+line);
					} // end colon check	
				} // end offset check
			} // end comment check			
		}	// end loop
		patchfile.close();
		switch(errorCode)
		{
			case 0:
				String dest = romsource.getParent();
				if (dest != null)
				{
					dest = dest + File.separatorChar+romsource.getName()+"_patched";
				}
				else
				{
					dest = romsource.getName()+"_patched";
				}
				File output = new File(dest);
				FileOutputStream fos = new FileOutputStream(output);
				fos.write(bmb.getBytes());
				fos.close();
				System.out.println("File patched OK");				
				break;
			case 1:
				if (patched == false)
				{
					System.out.println("Incorrect file for patch!");
				}
				else
				{
					System.out.println("File already patched");
				}
				break;
			case 2:
				System.out.println("End of file error");
				break;
		}	
	}			
}
