package org.jenison.datatype;


/**
 * @author mark
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class ByteConverter {

	
	public static int toUnsignedByteValue(byte b)
	{
		int i = (int)b;
		if (i >= 0)
		{
			return b;
		}
		// error checker
		if (i < -255)
		{
			throw new IllegalArgumentException("Byte "+b+" value invalid");
		}
		return 256+i;
	}
	
	static public String toBinary(byte b)
	{
		
		StringBuffer sb = new StringBuffer();
		int c = b;
		for (int i = 0;i < 8;++i)
		{
			sb.append((((c << i) & 0x80) == 0x80)?"1":"0");	
		}
		return sb.toString();	
	}	
	
	static public String toHex(byte b)
	{
		String ba = Integer.toHexString(b);
		ba = ba.trim();
		int start = (ba.length() > 1)?ba.length()-2:0;
		String ta = ba.substring(start,ba.length());
		ta = (ta.length() < 2)?"0"+ta:ta;
		ta = ta.toUpperCase();
		return ta;
		
	}

	static public String toHex(int i)
	{
		byte b = (byte)(i & 0x000000FF);
		return toHex(b);
	}
}
