/*
 * Created on Jun 7, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.jenison.datatype;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * @author Administrator
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class BitmapBuffer {

	byte [] bitmap;

	/**
	 * @param i
	 * @param tf
	 */
	public void setBit(int offset, int i, boolean tf) {
		if (tf)
		{
			bitmap[offset]=(byte)(bitmap[offset] | (byte)Math.pow(2, i % 8));
		}
		else
		{
			bitmap[offset]=(byte)(bitmap[offset] ^ (byte)Math.pow(2, i % 8));
		}
		
	}
	/**
	 * @param i
	 */
	public boolean getBit(int offset, int i) {
		// TODO Auto-generated method stub
		return ((bitmap[offset]>>i & 0x01) == 0x01);
	}
	/**
	 * @param offset
	 * @param buffersize
	 * @return
	 */
	public byte[] getBytes(int offset, int buffersize) {
		// TODO Auto-generated method stub
		byte[] temp = new byte[buffersize];
		// hack
		for (int i = 0;i<buffersize;++i)
		{
			temp[i] = bitmap[i+offset];
		}
		return temp;
	}
	
	public byte[] getBytes(int offset)
	{
		byte[] temp = new byte[bitmap.length-offset];
		for (int i =0;i<temp.length;++i)
		{
			temp[i] = bitmap[i+offset];
		}
		return temp;
	}
	
	public byte[] getBytes()
	{
		return bitmap;
	}
	/**
	 * @param string
	 * @return
	 */
	public static BitmapBuffer loadFile(String string) throws FileNotFoundException, IOException 
{
	File f = new File(string);
	return loadFile(f);
}

	public static BitmapBuffer loadFile(File f) throws FileNotFoundException, IOException
	{
	
	FileInputStream fis = null;
	byte[] get = new byte[(int) f.length()];
	fis = new FileInputStream(f);
	fis.read(get);
	BitmapBuffer buffer = new BitmapBuffer();
	buffer.setContents(get);
	return buffer;

	}
	/**
	 * @param get
	 */
	private void setContents(byte[] get) {
		bitmap = get;
	}
	/**
	 * 
	 */
	public int getSize() {
		return bitmap.length;
		
	}
	/**
	 * 
	 */
	public void dump(int start,int length) {
		int k = 0;
		StringBuffer sb = new StringBuffer();
		for (int i =start;i<length;++i)
		{
			sb.append(i+": ");
			for (int j = 7;j>=0;--j)
			{
				boolean t = (boolean)((bitmap[i]>>j & 0x01) == 0x01);
				if (t == true)
				{
					sb.append("1");
				}else {
					sb.append("0");
				}
				
			}
			
			System.out.println(sb.toString());
			sb.setLength(0);
		}
	}
	/**
	 * @param offset
	 * @return
	 */
	public byte getByte(int offset)
	{
		return bitmap[offset];
	}
	
	public void setByte(int offset, byte b)
	{
		bitmap[offset] = b;
	}
}