package org.jenison.app.patcher;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import org.jenison.datatype.BitmapBuffer;
import org.jenison.datatype.ByteConverter;

/**
 * @author mark
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class PatchCalc {

	public static void main(String[] args) throws IOException {
				
		if (validInputs(args))
		{	
			
			boolean result = calcPatch(args[0],args[1]);
			if (result)
			{
				System.out.println("Patch file created successfully");
			}
		}
		else
		{
			System.out.println("Usage: patchcalc <orig> <patched>");
			System.exit(1);
		}
	}
	
	private static boolean calcPatch(String origFilename, String patchFilename) throws IOException
	{
		boolean results = true;
		boolean changes = false;
		
		File origFile = new File(origFilename);
		File patchFile = new File(patchFilename);
		System.out.println("Loading "+origFile.getAbsolutePath());
		System.out.println("Length of file:"+origFile.length()+" bytes");
		BitmapBuffer orig = BitmapBuffer.loadFile(origFile);
		
		System.out.println("Loading "+patchFile.getAbsolutePath());
		System.out.println("Length of file:"+patchFile.length()+" bytes");
		BitmapBuffer patched = BitmapBuffer.loadFile(patchFile);
		if (validateFiles(orig,patched))
		{
			byte o;
			byte p;
						
			File patchfile = new File(patchFilename+".pat");
			patchfile.createNewFile();
			FileWriter fw = new FileWriter(patchfile);
			fw.write("; patch from "+origFile.getName()+" to "+patchFile.getName()+"\n");
			StringBuffer sb = new StringBuffer();
	
			// calc max padded zeros based on size;
			int size = orig.getSize();
			String test2 = Integer.toHexString(size);
			StringBuffer baseOffset = new StringBuffer();
			baseOffset.append("0000");
			for (int i = 4,n=test2.length();i<n;++i)
			{
				baseOffset.append("0");
			}
			// begin
			for (int i = 0, n = orig.getSize(); i<n;++i)
			{
				sb.setLength(0);
				o = orig.getByte(i);
				p = patched.getByte(i);
				
				if (o != p)
				{
					changes = true;
					
					sb.append("Offset $");
					String hexVal = Integer.toHexString(i);
					sb.append(baseOffset.substring(hexVal.length()));
					sb.append(hexVal);
					sb.append(": From $");
					sb.append(ByteConverter.toHex(o));
					sb.append(" To $");
					sb.append(ByteConverter.toHex(p));
					sb.append("\n");
					fw.write(sb.toString());
					//System.out.println(sb.toString());
				}				
			}
			fw.close();		
		}
		else
		{
			System.out.println("Files should be the same length! Orig size = "+orig.getSize()+", Patched size = "+patched.getSize());
			results = false;
		}
		if (!changes)
		{
			System.out.println("Files are identical!");
		}
		return results;
	}
	
	private static boolean validateFiles(BitmapBuffer orig, BitmapBuffer patched)
	{
		if (orig.getSize() != patched.getSize())
		{
			return false;		
		}
		return true;
	}
	private static boolean validInputs(String[] args)
	{
		if (args.length != 2)
		{
			return false;
		}
		return true;
	}
}
