// ---------
//	title.c
// ---------

#include "bombjack.h"

#define X_OFFSET		24	
#define Y_OFFSET		16
#define TILE_OFFSET		288
#define TITLE_PALETTE	4

// -----------------------------------------------------------------------------------------------
//
//	void initTitleScreen(void)
//
//	Initializes the title screen for display -- call updateTitleScreen() every frame to update
//	the colors.
//
// -----------------------------------------------------------------------------------------------

void initTitleScreen(void)
{
	static const u8 sprites[] = {8, 9, 10, 11, 20, 21, 22, 23, 24, 25, 26, 27};
	static const u16 titlePalette[] =
								{ 0x0000, 0x0fff, 0x000f, 0x008f, 0x090f, 0x0f50, 0x0f80, 0x0fc0 };
	int i;

	// nothing in the background...
	setBackground(5);
	clearBG0();
	clearBG1();
	setPalette(TITLE_PALETTE, 1, (u16*)titlePalette);
	hideSprites();

	REG_BG1HOFS = 4;
	REG_BG0HOFS = 0;
	REG_BG0VOFS = 0;

	// game title is made up of 32x32 sprites
	for(i = 0; i < sizeof(sprites); i+= 2)
	{
		setSpriteTile(i, sprites[i], 1);
		setSpriteXLoc(i, X_OFFSET + (i << 4));
		setSpriteYLoc(i, Y_OFFSET);
		setSpritePalette(i, TITLE_PALETTE);
	
		setSpriteTile(i + 1, sprites[i + 1], 1);
		setSpriteXLoc(i + 1, X_OFFSET + (i << 4));
		setSpriteYLoc(i + 1, Y_OFFSET + 32);
		setSpritePalette(i + 1, TITLE_PALETTE);
	}
	
	// and 8x8 tiles... ugh
	for(i = 0; i < 24; i+= 2)
	{
		kBG0Map[(((Y_OFFSET >> 3) + 8) * 32) + (X_OFFSET >> 3) + i] =
											((i * 2) + TILE_OFFSET + 2) | (TITLE_PALETTE << 12);
		kBG0Map[(((Y_OFFSET >> 3) + 8) * 32) + (X_OFFSET >> 3) + 1 + i] =
											((i * 2) + TILE_OFFSET    ) | (TITLE_PALETTE << 12);
		
		kBG0Map[(((Y_OFFSET >> 3) + 9) * 32) + (X_OFFSET >> 3) + i] =
											((i * 2) + TILE_OFFSET + 3) | (TITLE_PALETTE << 12);
		kBG0Map[(((Y_OFFSET >> 3) + 9) * 32) + (X_OFFSET >> 3) + 1 + i] =
											((i * 2) + TILE_OFFSET + 1) | (TITLE_PALETTE << 12);
	}

	// display the text
	drawBG0String("PUSH", 10, 14, 5);
	drawBG0String("START", 15, 14, 15);
	
	drawBG1String("ORIGINAL BY        LTD.", 4, 16, 5);
	drawBG1String("TEHKAN", 16, 16, 1);

	drawBG1String("CONVERSION BY", 2, 17, 5);
	drawBG1String("DENNIS MUNSIE", 16, 17, 12);
		
	// make sure the display is on -- incase of reset
	REG_DISPCNT = DISP_MODE_0 | DISP_BG0_ON | DISP_BG1_ON | DISP_BG3_ON | DISP_OBJ_ON | DISP_OM_1D;

} // of initTitleScreen()

// -----------------------------------------------------------------------------------------------
//
//	void updateTitleScreen(void)
//
//	Updates the colors on the screen to make the rotating color effect.
//
// -----------------------------------------------------------------------------------------------

void updateTitleScreen(void)
{
	static u8 count = 0;
	static u8 count2 = 0;
	static u16 color1 = 0x0f50;
	static u16 color2 = 0x0f80;
	static u16 color3 = 0x0fc0;
	
	if((gKeys == KEY_START_BUTTON) ||
	   (gKeys == KEY_A_BUTTON))
	{
		count = 0;
		count2 = 0;

		setGameMode(kGameMode);
		return;
	}

	count++;
	
	// rotate the colors every 5th frame
	if(count == 5)
	{
		u16 temp;
		
		setPaletteColor(TITLE_PALETTE, 5, color1);
		setPaletteColor(TITLE_PALETTE, 6, color2);
		setPaletteColor(TITLE_PALETTE, 7, color3);

		temp = color3; color3 = color2;	color2 = color1; color1 = temp;
		
		count = 0;
		count2++;

		if(count2 == 120)
		{
			setGameMode(kHighScoreScreenMode);
			count2 = 0;
		}
	}

} // of updateTitleScreen()
