// --------
//	main.c
// --------

#include "bombjack.h"

static u8 game_mode = kTitleScreenMode;

u16 gKeys = 0;			// keys currently pressed -- inverted

// -----------------------------------------------------------------------------------------------
//
//	void setGameMode(u8 mode)
//
//	Sets the current game mode, calling any necessary initialization for that mode.
//
// -----------------------------------------------------------------------------------------------

void setGameMode(u8 mode)
{
	switch(mode)
	{
		case kTitleScreenMode:
			initTitleScreen();
			break;

		case kHighScoreScreenMode:
			initHighScoreScreen();
			break;

		case kGameMode:
			initGameMode(2);
			break;
	}
	
	game_mode = mode;
	
} // of setGameMode()

// -----------------------------------------------------------------------------------------------
//
//	u8 readKeys(void)
//
//	Reads the keys and handles the 'kiss of death' key combo (A + B + Start + Select).
//
// -----------------------------------------------------------------------------------------------

static void readKeys(void)
{
	// invert the keys and make them available for later use
	gKeys = (~REG_P1 & KEY_ALL_MASK);
	
	// check for the 'kiss of death'
	if((gKeys & KEY_RESET) == KEY_RESET)
	{
		REG_DISPCNT = DISP_LCDC_OFF;
		
		// wait for all keys to be released
		while(!((REG_P1 & KEY_ALL_MASK) == KEY_ALL_MASK));
		setGameMode(kTitleScreenMode);
		gKeys = 0;
	}
	
} // of readKeys()

// -----------------------------------------------------------------------------------------------
//
//	void mainLoop(void)
//
//	Main loop of the game -- keeps everything synced to the retrace, updates OAM and calls into
//	the correct function for the current mode of the game.
//
// -----------------------------------------------------------------------------------------------

static void mainLoop(void)
{
	for( ; ; )
	{
		updateOAM();
		readKeys();
		rotateColors();

		switch(game_mode)
		{
			case kTitleScreenMode:
				updateTitleScreen();
				break;

			case kHighScoreScreenMode:
				updateHighScoreScreen();
				break;

			case kGameMode:
				updateGameMode();
				break;
		}

		VBlankIntrWait();
	}
	
} // of mainLoop()

// -----------------------------------------------------------------------------------------------
//
//	void AgbMain(void)
//
//	Entry point for the game -- initializes everything and starts the main loop.
//
// -----------------------------------------------------------------------------------------------

void AgbMain(void)
{
	// load up everything
	initializeGraphics();

	// setup our interrupt handler
	REG_INTERRUPT = (u32)interruptHandler;
	REG_DISPSTAT |= 0x8;
	REG_IE = INT_VBLANK;
	REG_IME = 1;

	// set the proper mode
	setGameMode(kTitleScreenMode);

	// and start running
	mainLoop();
	
} // of AgbMain() 
