// -------------
//	highscore.c
// -------------

#include "bombjack.h"

static const char *place[] =
{
	" 1ST", " 2ND", " 3RD", " 4TH", " 5TH", " 6TH", " 7TH", " 8TH", " 9TH", "10TH"
};

highScoreEntry gHighScores[] =
{
	{ "T.T", 0x1000, 1 },
	{ "E.E", 0x1000, 1 },
	{ "H.H", 0x1000, 1 },
	{ "K.K", 0x1000, 1 },
	{ "A.A", 0x1000, 1 },
	{ "N.N", 0x1000, 1 },
	{ "L.L", 0x1000, 1 },
	{ "T.T", 0x1000, 1 },
	{ "D.D", 0x1000, 1 },
	{ "...", 0x1000, 1 }
};

// ------------------------------------------------------------------------------------------
//
//	void initHighScoreScreen(void)
//
//	Initializes the screen properly for displaying the high score screen.
//
// ------------------------------------------------------------------------------------------

void initHighScoreScreen(void)
{
	int i;
	
	// clear the screen
	setBackground(5);
	clearBG0();
	clearBG1();
	hideSprites();
	
	REG_BG1HOFS = 4;
	REG_BG0HOFS = 0;
	REG_BG0VOFS = 0;

	drawBG0String("BEST PLAYERS", 9, 2, 6);

	for(i = 0; i < 10; i++)
	{
		char temp[] = "1";
		
		drawBG0String(place[i], 2, 5 + i, 5);
		drawBG0String(gHighScores[i].initials, 16, 5 + i, 5);
		drawBG0String("ROUND", 21, 5 + i, 5);

		temp[0] = '0' + gHighScores[i].round;
		
		if(i == 0)
		{
			drawBG0BCD(gHighScores[i].score, 6, 5, 15);
			drawBG0String("0", 14, 5, 15);
			drawBG0String(temp, 27, 5, 15);
		}
		
		else
		{
			drawBG0BCD(gHighScores[i].score, 6, 5 + i, 5);
			drawBG0String("0", 14, 5 + i, 5);
			drawBG0String(temp, 27, 5 + i, 5);
		}
	}
	
	drawBG0String("\072\0731984        LTD.", 6, 17, 5);
	drawBG0String("TEHKAN", 13, 17, 15);

} // of initHighScoreScreen()

// ------------------------------------------------------------------------------------------
//
//	void updateHighScoreScreen(void)
//
//	Called from the main loop to update the high score screen -- if the A or the Start
//	button is pressed, it will start the game mode -- otherwise, after 10 seconds, it will
//	go back to the title screen.
//
// ------------------------------------------------------------------------------------------

void updateHighScoreScreen(void)
{
	static u8 count = 0;

	if((gKeys == KEY_START_BUTTON) || (gKeys == KEY_A_BUTTON))
	{
		count = 0;
		setGameMode(kGameMode);
		return;
	}
	
	count++;
	if(count == 600)
	{
		setGameMode(kTitleScreenMode);
		count = 0;
	}
	
} // of updateHighScoreScreen()
