#ifndef _BOMBJACK_H_
#define _BOMBJACK_H_

#include <gba.h>

// -----------------
//	Boolean defines
// -----------------

#define FALSE		0
#define TRUE		1

#define OFF			0
#define ON			1

#define DISABLE		0
#define ENABLE		1

// --------
//	bios.s
// --------

extern void VBlankIntrWait(void);

// --------
//	game.c
// --------

extern void initGameMode(u8 players);
extern void updateGameMode(void);

// ------------
//	graphics.c
// ------------

// -------------------------------------------------------------------------------------------
//
//  VRAM mapping
//
//  0x00000-0x0349f - character tile set (421 tiles)
//  0x04000-0x0bfff - background tile set (1024 tiles)
//  0x0c000-0x0c3ff - bg0 map (32x32)
//  0x0c800-0x0caff - bg1 map (32x32)
//  0x0d000-0x0d3ff - bg3 map (32x32)
//  0x10000-0x17fff - sprite tile set
//
// -------------------------------------------------------------------------------------------

#define kCharTileset        ((u32*)VRAM)
#define kBackgroundTileset  ((u32*)0x06004000)
#define kBG0Map             ((u16*)0x0600c000)
#define kBG1Map				((u16*)0x0600c800)
#define kBG3Map             ((u16*)0x0600d000)
#define kSpriteTileset      ((u32*)OAM_DATA)

extern OAMEntry gSprites[];

#define setSpriteXLoc(sprite, x)	{ \
										gSprites[(sprite)].attribute1 &= 0xfe00; \
										gSprites[(sprite)].attribute1 |= ((x) & 0x1ff); \
									}

#define setSpriteYLoc(sprite, y)	{ \
										gSprites[(sprite)].attribute0 &= 0xff00; \
										gSprites[(sprite)].attribute0 |= ((y) & 0xff); \
									}

#define setSpritePalette(sprite, n)	{ \
										gSprites[(sprite)].attribute2 &= 0x0fff; \
										gSprites[(sprite)].attribute2 |= ((n) << 12); \
									}

#define updateOAM()					{ \
										REG_DM3SAD = (u32)gSprites; \
										REG_DM3DAD = (u32)OAM_MEM; \
										REG_DM3CNT = 128 | DMA_32NOW; \
									}

#define clearBG0()					{ \
										u32 zero = 0; \
										REG_DM3SAD = (u32)&zero; \
										REG_DM3DAD = (u32)kBG0Map; \
										REG_DM3CNT = 512 | DMA_SOURCE_FIXED | DMA_32NOW; \
									}

#define clearBG1()					{ \
										u32 zero = 0; \
										REG_DM3SAD = (u32)&zero; \
										REG_DM3DAD = (u32)kBG1Map; \
										REG_DM3CNT = 512 | DMA_SOURCE_FIXED | DMA_32NOW; \
									}

#define drawBG0String(string, x, y, palette) drawString(kBG0Map, (string), (x), (y), (palette))
#define drawBG1String(string, x, y, palette) drawString(kBG1Map, (string), (x), (y), (palette))

#define drawBG0BCD(num, x, y, palette) drawBCD(kBG0Map, (num), (x), (y), (palette))
#define drawBG1BCD(num, x, y, palette) drawBCD(kBG1Map, (num), (x), (y), (palette))

#define draw1x2TileBG1(num, x, y, palette)	{ \
							kBG1Map[((y) << 5) + (x)] = (num) | ((palette) << 12); \
							kBG1Map[((y + 1) << 5) + (x)] = ((num) + 1) | ((palette) << 12); \
											}

#define draw2x2TileBG1(num, x, y, palette)	{ \
							kBG1Map[((y) << 5) + (x)] = ((num) + 2) | ((palette) << 12); \
							kBG1Map[((y) << 5) + (x) + 1] = (num) | ((palette) << 12); \
							kBG1Map[(((y) + 1) << 5) + (x)] = ((num) + 3) | ((palette) << 12); \
							kBG1Map[(((y) + 1) << 5) + (x) + 1] = ((num) + 1) | ((palette) << 12); \
											}

extern void rotateColors(void);
extern void setBackground(u32 background);
extern void hideSprites(void);
extern void setPalette(u8 palette_num, u8 palettes, u16 *palette_base);
extern void setPaletteColor(u8 palette_num, u8 color_num, u16 palette_color);
extern void setSpriteTile(u8 sprite, u8 tile, u8 flag32);
extern void initializeGraphics(void);
extern void drawString(u16 *map, const char *string, u8 x, u8 y, u16 palette);
extern void drawBCD(u16 *map, u32 num, u8 x, u8 y, u16 palette);

// -------------
//	highscore.c
// -------------

typedef struct
{
	char *initials;
	u16 score;
	u8 round;

} highScoreEntry;

extern highScoreEntry gHighScores[];

extern void initHighScoreScreen(void);
extern void updateHighScoreScreen(void);

// -------------
//	interrupt.s
// -------------

extern void interruptHandler(void);

// --------
//	main.c
// --------

extern u16 gKeys;

#define kTitleScreenMode 0
#define kHighScoreScreenMode 1
#define kGameMode 2

extern void setGameMode(u8 mode);

// ---------
//	title.c
// ---------

extern void initTitleScreen(void);
extern void updateTitleScreen(void);

#endif /* _BOMBJACK_H_ */
